/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.ali.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.PutObjectResult;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssClientTams {
    private static final Logger log = LoggerFactory.getLogger(OssClientTams.class);
    private static volatile OssClientTams inst;
    private final OSS client;

    public OSS getClient() {
        return this.client;
    }

    private OssClientTams() {
        OSS client;
        this.client = client = new OSSClientBuilder().build(Conf.get((String)"common.ali.profile.endpoint"), Conf.get((String)"common.ali.profile.accessKey"), Conf.get((String)"common.ali.profile.secretKey"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OssClientTams getInst() {
        if (inst != null) return inst;
        Class<OssClientTams> clazz = OssClientTams.class;
        synchronized (OssClientTams.class) {
            if (inst != null) return inst;
            inst = new OssClientTams();
            // ** MonitorExit[var0] (shouldn't be in output)
            return inst;
        }
    }

    public OSSObject getObject(String key) {
        OSSObject ossObject = this.client.getObject(Conf.get((String)"common.ali.oss.default.bucketName"), key);
        return ossObject;
    }

    public Result saveFileByKey(String key, String parentDirPath) {
        OSSObject ossObject = this.getObject(key);
        try {
            String filePath = IOUtil.mergeFolderAndFilePath((String)parentDirPath, (String[])new String[]{key.substring(key.lastIndexOf("/") + 1)});
            FileUtils.copyInputStreamToFile((InputStream)ossObject.getObjectContent(), (File)new File(filePath));
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
        return Result.getSuc();
    }

    public String putObject(String key, File file) {
        PutObjectResult putObject = this.client.putObject(Conf.get((String)"common.ali.oss.default.bucketName"), key, file);
        return putObject.getVersionId();
    }

    public OSSObject getObjectByBucketNameKey(String bucketNameAndKey) {
        String pathtrue = bucketNameAndKey.charAt(0) == '/' ? bucketNameAndKey.substring(1) : bucketNameAndKey;
        int firstIndexOf = pathtrue.indexOf("/");
        OSSObject object = this.client.getObject(pathtrue.substring(0, firstIndexOf), pathtrue.substring(firstIndexOf + 1));
        return object;
    }

    public List<String> getFileKeyByDir(String dirPath) {
        ArrayList<String> retlist = new ArrayList<String>();
        this.getFileKeyByDir(dirPath, null, retlist);
        return retlist;
    }

    private void getFileKeyByDir(String dirPath, String continuationToken, List<String> retlist) {
        ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request(Conf.get((String)"common.ali.oss.default.bucketName"));
        listObjectsRequest.setDelimiter("/");
        if (StringUtil.isNotNull((Object)continuationToken)) {
            listObjectsRequest.setContinuationToken(continuationToken);
        }
        listObjectsRequest.setPrefix(dirPath);
        ListObjectsV2Result list = this.client.listObjectsV2(listObjectsRequest);
        List objectSummaries = list.getObjectSummaries();
        for (OSSObjectSummary ossObjectSummary : objectSummaries) {
            retlist.add(ossObjectSummary.getKey());
        }
        if (StringUtil.isNotNull((Object)list.getNextContinuationToken())) {
            this.getFileKeyByDir(dirPath, list.getNextContinuationToken(), retlist);
        }
    }

    public void delKeyByDir(String dirPath) {
        List<String> allKey = this.getFileKeyByDir(dirPath);
        this.delKeys(allKey.toArray(new String[allKey.size()]));
    }

    public void delKeys(String ... keys) {
        for (String key : keys) {
            this.client.deleteObject(Conf.get((String)"common.ali.oss.default.bucketName"), key);
        }
    }
}

