package net.wicp.tams.common.ali.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;

import net.wicp.tams.common.Conf;

public class OssClientTams {
	private static volatile OssClientTams inst;

	private final OSS client;

	public OSS getClient() {
		return client;
	}

	private OssClientTams() {
		OSS client = new OSSClientBuilder().build(Conf.get("common.ali.profile.endpoint"),
				Conf.get("common.ali.profile.accessKey"), Conf.get("common.ali.profile.secretKey"));
		this.client = client;
	}

	public static OssClientTams getInst() {
		if (inst == null) {
			synchronized (OssClientTams.class) {
				if (inst == null) {
					inst = new OssClientTams();
				}
			}
		}
		return inst;
	}

	public OSSObject getObject(String key) {
		OSSObject ossObject = this.client.getObject(Conf.get("common.ali.oss.default.bucketName"), key);
		return ossObject;
	}

	/***
	 * 把bucketName和key组成一个key 如：lc-bigdata/doris/check_system.sh
	 * 表示：lc-bigdata的bucketName的doris/check_system.sh路径
	 * 
	 * @param bucketNameAndKey 带有bucketname的key
	 * @return
	 */
	public OSSObject getObjectByBucketNameKey(String bucketNameAndKey) {
		String pathtrue = bucketNameAndKey.charAt(0) == '/' ? bucketNameAndKey.substring(1) : bucketNameAndKey;
		int firstIndexOf = pathtrue.indexOf("/");
		OSSObject object = this.client.getObject(pathtrue.substring(0, firstIndexOf),
				pathtrue.substring(firstIndexOf + 1));
		return object;
	}
}
