package net.wicp.tams.common.ali;

import net.wicp.tams.common.ali.oss.OssClientTams;

public class AliClientManager {
	private static volatile AliClientManager aliClientOnlyOne;
	private final OssClientTams ossClient;

	public OssClientTams getOssClient() {
		return ossClient;
	}

	private AliClientManager() {
		this.ossClient = OssClientTams.getInst();

	}

	public static AliClientManager getInst() {
		if (aliClientOnlyOne == null) {
			synchronized (AliClientManager.class) {
				if (aliClientOnlyOne == null) {
					aliClientOnlyOne = new AliClientManager();
				}
			}
		}
		return aliClientOnlyOne;
	}

}
