/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.source;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import xapi.source.api.CharIterator;
import xapi.source.api.Lexer;
import xapi.source.impl.LexerForWords;
import xapi.source.impl.LexerStack;
import xapi.source.impl.StringCharIterator;

public class LexerTest {
    @Test
    public void testLexerForWords() {
        TestLexerForWords lex = new TestLexerForWords();
        lex.consume((CharIterator)new StringCharIterator("Hello World"));
        Assert.assertEquals((String)(lex.words + " != Hello World"), (long)2L, (long)lex.words.size());
        Assert.assertEquals((Object)"Hello", lex.words.get(0));
        Assert.assertEquals((Object)"World", lex.words.get(1));
    }

    @Test
    public void testLexerStack() {
        TestLexerForHello hello = new TestLexerForHello();
        TestLexerForWorld world = new TestLexerForWorld();
        new LexerStack().addLexer((LexerStack)hello).addLexer((LexerStack)world).consume((CharIterator)new StringCharIterator("Hello World"));
        Assert.assertTrue((boolean)hello.sawHello);
        Assert.assertTrue((boolean)world.sawWorld);
    }

    private class TestLexerForWorld
    extends LexerStack {
        boolean sawWorld;

        private TestLexerForWorld() {
        }

        protected Lexer onWord(LexerStack parent, String word, CharIterator str) {
            if ("World".equals(word)) {
                this.sawWorld = true;
            }
            return super.onWord(parent, word, str);
        }
    }

    private class TestLexerForHello
    extends LexerStack {
        boolean sawHello;

        private TestLexerForHello() {
        }

        protected Lexer onWord(LexerStack parent, String word, CharIterator str) {
            if ("Hello".equals(word)) {
                this.sawHello = true;
            }
            return super.onWord(parent, word, str);
        }
    }

    private class TestLexerForWords
    extends LexerForWords {
        private ArrayList<String> words = new ArrayList();

        private TestLexerForWords() {
        }

        protected Lexer onWord(String word, CharIterator str) {
            this.words.add(word);
            return super.onWord(word, str);
        }
    }
}

