/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.collect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.junit.Assert;
import org.junit.Test;
import xapi.collect.impl.SimpleLinkedList;
import xapi.test.collect.AbstractLinkedListTest;

public class SimpleLinkedListTest
extends AbstractLinkedListTest<SimpleLinkedList<String>> {
    @Test
    public void testListIterator_Add() {
        ListIterator listItr = ((SimpleLinkedList)this.stack).listIterator();
        listItr.next();
        listItr.add("one.five");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iterator(), "one", "one.five", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).listIterator(), "one", "one.five", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "two", "one.five", "one");
        Assert.assertEquals((Object)"one", (Object)((SimpleLinkedList)this.stack).head());
        Assert.assertEquals((Object)"two", (Object)((SimpleLinkedList)this.stack).tail());
    }

    @Test
    public void testListIterator_AddEnd() {
        ListIterator<String> listItr = ((SimpleLinkedList)this.stack).listIterator();
        this.assertIteratorContents((Iterator<String>)listItr, "one", "two");
        listItr.add("three");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iterator(), "one", "two", "three");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).listIterator(), "one", "two", "three");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "three", "two", "one");
        Assert.assertEquals((Object)"one", (Object)((SimpleLinkedList)this.stack).head());
        Assert.assertEquals((Object)"three", (Object)((SimpleLinkedList)this.stack).tail());
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        listItr = list.listIterator();
        this.assertIteratorContents(listItr, "one", "two");
        listItr.add("three");
        this.assertIteratorContents(list.listIterator(), "one", "two", "three");
    }

    @Test
    public void testListIterator_AddToBeginning() {
        ((SimpleLinkedList)this.stack).listIterator().add("zero");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iterator(), "zero", "one", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).listIterator(), "zero", "one", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "two", "one", "zero");
        Assert.assertEquals((Object)"zero", (Object)((SimpleLinkedList)this.stack).head());
        Assert.assertEquals((Object)"two", (Object)((SimpleLinkedList)this.stack).tail());
    }

    @Test
    public void testListIterator_ManyOperations() {
        ListIterator<String> listItr = ((SimpleLinkedList)this.stack).listIterator();
        listItr.next();
        listItr.add("one.five");
        listItr.add("one.seven.five");
        listItr.previous();
        listItr.previous();
        listItr.add("one.two.five");
        listItr.next();
        listItr.previous();
        listItr.previous();
        listItr.previous();
        listItr.previous();
        this.assertIteratorContents((Iterator<String>)listItr, "one", "one.two.five", "one.five", "one.seven.five", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iterator(), "one", "one.two.five", "one.five", "one.seven.five", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).listIterator(), "one", "one.two.five", "one.five", "one.seven.five", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "two", "one.seven.five", "one.five", "one.two.five", "one");
        Assert.assertEquals((Object)"one", (Object)((SimpleLinkedList)this.stack).head());
        Assert.assertEquals((Object)"two", (Object)((SimpleLinkedList)this.stack).tail());
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        listItr = list.listIterator();
        listItr.next();
        listItr.add("one.five");
        listItr.add("one.seven.five");
        listItr.previous();
        listItr.previous();
        listItr.add("one.two.five");
        listItr.previous();
        listItr.previous();
        this.assertIteratorContents(listItr, "one", "one.two.five", "one.five", "one.seven.five", "two");
        this.assertIteratorContents(list.iterator(), "one", "one.two.five", "one.five", "one.seven.five", "two");
    }

    @Test
    public void testListIterator_Remove() {
        ((SimpleLinkedList)this.stack).add((Object)"three");
        ListIterator listItr = ((SimpleLinkedList)this.stack).listIterator();
        listItr.next();
        listItr.remove();
        listItr.next();
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iterator(), "one", "three");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).listIterator(), "one", "three");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "three", "one");
        Assert.assertEquals((Object)"one", (Object)((SimpleLinkedList)this.stack).head());
        Assert.assertEquals((Object)"three", (Object)((SimpleLinkedList)this.stack).tail());
    }

    @Test
    public void testListIterator_RemoveAtBeginning() {
        ((SimpleLinkedList)this.stack).add((Object)"three");
        ListIterator listItr = ((SimpleLinkedList)this.stack).listIterator();
        listItr.remove();
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iterator(), "two", "three");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).listIterator(), "two", "three");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "three", "two");
        Assert.assertEquals((Object)"two", (Object)((SimpleLinkedList)this.stack).head());
        Assert.assertEquals((Object)"three", (Object)((SimpleLinkedList)this.stack).tail());
    }

    @Test
    public void testListIterator_RemoveAtEnd() {
        ((SimpleLinkedList)this.stack).add((Object)"three");
        ListIterator listItr = ((SimpleLinkedList)this.stack).listIterator();
        listItr.next();
        listItr.next();
        listItr.remove();
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iterator(), "one", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).listIterator(), "one", "two");
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "two", "one");
        Assert.assertEquals((Object)"one", (Object)((SimpleLinkedList)this.stack).head());
        Assert.assertEquals((Object)"two", (Object)((SimpleLinkedList)this.stack).tail());
    }

    @Test
    public void testReverseForEach() {
        String[] expected = new String[]{"two"};
        Iterator reverse = ((SimpleLinkedList)this.stack).iteratorReverse();
        while (reverse.hasNext()) {
            String s = (String)reverse.next();
            Assert.assertEquals((Object)expected[0], (Object)s);
            expected[0] = "one";
        }
    }

    @Test
    public void testReverseIterate() {
        this.assertIteratorContents(((SimpleLinkedList)this.stack).iteratorReverse(), "two", "one");
    }

    @Override
    protected SimpleLinkedList<String> newList() {
        return new SimpleLinkedList();
    }
}

