/*
 * Decompiled with CFR 0.152.
 */
package xapi.source.read;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import xapi.source.read.JavaLexer;
import xapi.source.read.JavaModel;

public class JavaModelTest {
    @Test
    public void testSimpleParam() {
        JavaModel.IsParameter param = JavaLexer.lexParam((CharSequence)"@NotNull String param");
        Assert.assertEquals((Object)"String", (Object)param.getType());
        Assert.assertEquals((Object)"param", (Object)param.getName());
        Iterator annos = param.annotations.getAnnotations().iterator();
        Assert.assertTrue((boolean)annos.hasNext());
        Assert.assertEquals((Object)"NotNull", (Object)((JavaModel.IsAnnotation)annos.next()).qualifiedName);
    }

    @Test
    public void testArrayParam() {
        JavaModel.IsParameter param = JavaLexer.lexParam((CharSequence)"Class<?>[] param");
        Assert.assertEquals((Object)"Class<?>[]", (Object)param.getType());
        Assert.assertEquals((Object)"param", (Object)param.getName());
    }

    @Test
    public void testComplexParam() {
        JavaModel.IsParameter param = JavaLexer.lexParam((CharSequence)"final @Named(\"param\") @NotNull String param");
        Assert.assertEquals((Object)"String", (Object)param.getType());
        Assert.assertEquals((Object)"param", (Object)param.getName());
        Iterator annos = param.annotations.getAnnotations().iterator();
        Assert.assertTrue((boolean)annos.hasNext());
        JavaModel.IsAnnotation anno = (JavaModel.IsAnnotation)annos.next();
        Assert.assertEquals((Object)"Named", (Object)anno.qualifiedName);
        Iterator members = anno.members.iterator();
        Assert.assertTrue((boolean)members.hasNext());
        Assert.assertEquals((Object)"\"param\"", (Object)((JavaModel.AnnotationMember)members.next()).value);
        Assert.assertTrue((boolean)annos.hasNext());
        Assert.assertEquals((Object)"NotNull", (Object)((JavaModel.IsAnnotation)annos.next()).qualifiedName);
    }
}

