/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.redis.service.impl;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.wenzuo.atom.core.util.JsonUtils;
import net.wenzuo.atom.redis.service.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

@ConditionalOnProperty(value={"atom.redis.cache-service"}, matchIfMissing=true)
public class CacheServiceImpl
implements CacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheServiceImpl.class);
    private static final String NULL_VALUE = "";
    private final StringRedisTemplate stringRedisTemplate;

    @Override
    public <T> T cache(String key, Supplier<T> supplier, Class<T> target) {
        return (T)this.cache(key, supplier, (String json) -> JsonUtils.toObject((String)json, (Class)target));
    }

    @Override
    public <T> T cache(String key, Supplier<T> supplier, Class<?> wrapper, Class<?> ... inners) {
        return (T)this.cache(key, supplier, (String json) -> JsonUtils.toObject((String)json, (Class)wrapper, (Class[])inners));
    }

    private <T> T cache(String key, Supplier<T> supplier, Function<String, T> deserializer) {
        ValueOperations ops = this.stringRedisTemplate.opsForValue();
        String json = (String)ops.get((Object)key);
        if (json != null) {
            return deserializer.apply(json);
        }
        T data = supplier.get();
        if (data == null) {
            ops.set((Object)key, (Object)NULL_VALUE);
        } else {
            ops.set((Object)key, (Object)JsonUtils.toJson(data));
        }
        return data;
    }

    @Override
    public void evict(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    @Override
    public void evict(Collection<String> keys) {
        this.stringRedisTemplate.delete(keys);
    }

    @Override
    public void evictAll(String pattern) {
        Set keys = this.stringRedisTemplate.keys((Object)pattern);
        this.stringRedisTemplate.delete((Collection)keys);
    }

    @Generated
    public CacheServiceImpl(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

