/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.redis.config;

import lombok.Generated;
import net.wenzuo.atom.core.util.JsonUtils;
import net.wenzuo.atom.redis.config.PrefixStringRedisSerializer;
import net.wenzuo.atom.redis.config.RedisProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
public class RedisConfiguration {
    private final RedisProperties redisProperties;

    @ConditionalOnProperty(value={"atom.redis.string-redis-template"}, matchIfMissing=true)
    @Bean
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory factory) {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory(factory);
        PrefixStringRedisSerializer keySerializer = this.prefixStringRedisSerializer();
        RedisSerializer stringSerializer = RedisSerializer.string();
        stringRedisTemplate.setKeySerializer((RedisSerializer)keySerializer);
        stringRedisTemplate.setHashKeySerializer(stringSerializer);
        stringRedisTemplate.setValueSerializer(stringSerializer);
        stringRedisTemplate.setHashValueSerializer(stringSerializer);
        stringRedisTemplate.setEnableTransactionSupport(true);
        stringRedisTemplate.afterPropertiesSet();
        return stringRedisTemplate;
    }

    @ConditionalOnProperty(value={"atom.redis.redis-template"}, matchIfMissing=true)
    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        PrefixStringRedisSerializer keySerializer = this.prefixStringRedisSerializer();
        RedisSerializer hashKeySerializer = RedisSerializer.string();
        RedisSerializer<Object> valueSerializer = this.jacksonRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setHashKeySerializer(hashKeySerializer);
        redisTemplate.setValueSerializer(valueSerializer);
        redisTemplate.setHashValueSerializer(valueSerializer);
        redisTemplate.setEnableTransactionSupport(true);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public RedisCacheConfiguration redisCacheConfiguration() {
        return RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(name -> name + ":").serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)this.prefixStringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(this.jacksonRedisSerializer()));
    }

    private RedisSerializer<Object> jacksonRedisSerializer() {
        return new GenericJackson2JsonRedisSerializer(JsonUtils.objectMapper);
    }

    private PrefixStringRedisSerializer prefixStringRedisSerializer() {
        return new PrefixStringRedisSerializer(this.redisProperties.getPrefix());
    }

    @Generated
    public RedisConfiguration(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }
}

