/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.redis.config;

import java.nio.charset.Charset;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class PrefixStringRedisSerializer
extends StringRedisSerializer {
    private final String prefix;

    public PrefixStringRedisSerializer() {
        this.prefix = "";
    }

    public PrefixStringRedisSerializer(String prefix) {
        this.prefix = prefix;
    }

    public PrefixStringRedisSerializer(Charset charset) {
        super(charset);
        this.prefix = "";
    }

    public PrefixStringRedisSerializer(Charset charset, String prefix) {
        super(charset);
        this.prefix = prefix;
    }

    public byte[] serialize(String value) throws SerializationException {
        return super.serialize(this.prefix + value);
    }

    public String deserialize(byte[] bytes) throws SerializationException {
        String deserialized = super.deserialize(bytes);
        if (deserialized == null) {
            return null;
        }
        if (deserialized.startsWith(this.prefix)) {
            return deserialized.substring(this.prefix.length());
        }
        return deserialized;
    }
}

