/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.redis.service.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.wenzuo.atom.core.util.JsonUtils;
import net.wenzuo.atom.redis.service.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(value={"atom.redis.redis-service"}, matchIfMissing=true)
@Service
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    private final StringRedisTemplate stringRedisTemplate;

    @Override
    public void set(String key, Object value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JsonUtils.toJson((Object)value));
    }

    @Override
    public void set(String key, Object value, long timeout, TimeUnit unit) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JsonUtils.toJson((Object)value), timeout, unit);
    }

    @Override
    public void set(String key, Object value, Duration duration) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JsonUtils.toJson((Object)value), duration);
    }

    @Override
    public Boolean setIfAbsent(String key, Object value) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)JsonUtils.toJson((Object)value));
    }

    @Override
    public Boolean setIfAbsent(String key, Object value, long timeout, TimeUnit unit) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)JsonUtils.toJson((Object)value), timeout, unit);
    }

    @Override
    public Boolean setIfAbsent(String key, Object value, Duration timeout) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)JsonUtils.toJson((Object)value), timeout);
    }

    @Override
    public Boolean setIfPresent(String key, Object value) {
        return this.stringRedisTemplate.opsForValue().setIfPresent((Object)key, (Object)JsonUtils.toJson((Object)value));
    }

    @Override
    public Boolean setIfPresent(String key, Object value, long timeout, TimeUnit unit) {
        return this.stringRedisTemplate.opsForValue().setIfPresent((Object)key, (Object)JsonUtils.toJson((Object)value), timeout, unit);
    }

    @Override
    public Boolean setIfPresent(String key, Object value, Duration timeout) {
        return this.stringRedisTemplate.opsForValue().setIfPresent((Object)key, (Object)JsonUtils.toJson((Object)value), timeout);
    }

    @Override
    public void multiSet(Map<String, ?> map) {
        HashMap stringMap = new HashMap();
        map.forEach((k, v) -> stringMap.put(k, JsonUtils.toJson((Object)v)));
        this.stringRedisTemplate.opsForValue().multiSet(stringMap);
    }

    @Override
    public Boolean multiSetIfAbsent(Map<String, ?> map) {
        HashMap stringMap = new HashMap();
        map.forEach((k, v) -> stringMap.put(k, JsonUtils.toJson((Object)v)));
        return this.stringRedisTemplate.opsForValue().multiSetIfAbsent(stringMap);
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)key)), clazz);
    }

    @Override
    public <T> T get(String key, Class<?> wrapper, Class<?> ... inners) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)key)), wrapper, (Class[])inners);
    }

    @Override
    public <T> T getAndDelete(String key, Class<T> clazz) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndDelete((Object)key)), clazz);
    }

    @Override
    public <T> T getAndDelete(String key, Class<?> wrapper, Class<?> ... inners) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndDelete((Object)key)), wrapper, (Class[])inners);
    }

    @Override
    public <T> T getAndExpire(String key, long timeout, TimeUnit unit, Class<T> clazz) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndExpire((Object)key, timeout, unit)), clazz);
    }

    @Override
    public <T> T getAndExpire(String key, long timeout, TimeUnit unit, Class<?> wrapper, Class<?> ... inners) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndExpire((Object)key, timeout, unit)), wrapper, (Class[])inners);
    }

    @Override
    public <T> T getAndExpire(String key, Duration timeout, Class<T> clazz) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndExpire((Object)key, timeout)), clazz);
    }

    @Override
    public <T> T getAndExpire(String key, Duration timeout, Class<?> wrapper, Class<?> ... inners) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndExpire((Object)key, timeout)), wrapper, (Class[])inners);
    }

    @Override
    public <T> T getAndPersist(String key, Class<T> clazz) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndPersist((Object)key)), clazz);
    }

    @Override
    public <T> T getAndPersist(String key, Class<?> wrapper, Class<?> ... inners) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndPersist((Object)key)), wrapper, (Class[])inners);
    }

    @Override
    public <T> T getAndSet(String key, Object value, Class<T> clazz) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndSet((Object)key, (Object)JsonUtils.toJson((Object)value))), clazz);
    }

    @Override
    public <T> T getAndSet(String key, Object value, Class<?> wrapper, Class<?> ... inners) {
        return (T)JsonUtils.toObject((String)((String)this.stringRedisTemplate.opsForValue().getAndSet((Object)key, (Object)JsonUtils.toJson((Object)value))), wrapper, (Class[])inners);
    }

    @Override
    public <T> List<T> multiGet(Collection<String> keys, Class<T> clazz) {
        List list = this.stringRedisTemplate.opsForValue().multiGet(keys);
        if (list == null) {
            return null;
        }
        return list.stream().map(v -> JsonUtils.toObject((String)v, (Class)clazz)).collect(Collectors.toList());
    }

    @Override
    public Long increment(String key) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key);
    }

    @Override
    public Long increment(String key, long delta) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    @Override
    public Double increment(String key, double delta) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    @Override
    public Long decrement(String key) {
        return this.stringRedisTemplate.opsForValue().decrement((Object)key);
    }

    @Override
    public Long decrement(String key, long delta) {
        return this.stringRedisTemplate.opsForValue().decrement((Object)key, delta);
    }

    @Override
    public Boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    @Override
    public Long countExistingKeys(Collection<String> keys) {
        return this.stringRedisTemplate.countExistingKeys(keys);
    }

    @Override
    public Boolean delete(String key) {
        return this.stringRedisTemplate.delete((Object)key);
    }

    @Override
    public Long delete(Collection<String> keys) {
        return this.stringRedisTemplate.delete(keys);
    }

    @Override
    public Boolean unlink(String key) {
        return this.stringRedisTemplate.unlink((Object)key);
    }

    @Override
    public Long unlink(Collection<String> keys) {
        return this.stringRedisTemplate.unlink(keys);
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    @Override
    public void rename(String oldKey, String newKey) {
        this.stringRedisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    @Override
    public Boolean renameIfAbsent(String oldKey, String newKey) {
        return this.stringRedisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    @Override
    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.stringRedisTemplate.expire((Object)key, timeout, unit);
    }

    @Override
    public Boolean expire(String key, Duration duration) {
        return this.stringRedisTemplate.expire((Object)key, duration);
    }

    @Override
    public Boolean expireAt(String key, Date date) {
        return this.stringRedisTemplate.expireAt((Object)key, date);
    }

    @Override
    public Boolean expireAt(String key, Instant expireAt) {
        return this.stringRedisTemplate.expireAt((Object)key, expireAt);
    }

    @Override
    public Boolean persist(String key) {
        return this.stringRedisTemplate.persist((Object)key);
    }

    @Override
    public Long getExpire(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    @Override
    public Long getExpire(String key, TimeUnit timeUnit) {
        return this.stringRedisTemplate.getExpire((Object)key, timeUnit);
    }

    public RedisServiceImpl(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

