/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.mybatisplus.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.wenzuo.atom.api.param.PageRequest;
import net.wenzuo.atom.api.param.PageResponse;
import org.springframework.lang.NonNull;

public abstract class PageUtils {
    @NonNull
    public static <T> Page<T> toPage(@NonNull PageRequest request) {
        return new Page(request.getPageNo(), request.getPageSize());
    }

    @NonNull
    public static <T> PageResponse<T> toPageResponse(@NonNull Page<T> page) {
        PageResponse pageResponse = new PageResponse();
        pageResponse.setPageNo(page.getCurrent());
        pageResponse.setPageSize(page.getSize());
        pageResponse.setTotalRow(page.getTotal());
        pageResponse.setTotalPage(page.getPages());
        pageResponse.setItems(page.getRecords());
        return pageResponse;
    }

    @NonNull
    public static <T, R> PageResponse<R> toPageResponse(@NonNull Page<T> page, Function<T, R> function) {
        PageResponse pageResponse = new PageResponse();
        pageResponse.setPageNo(page.getCurrent());
        pageResponse.setPageSize(page.getSize());
        pageResponse.setTotalRow(page.getTotal());
        pageResponse.setTotalPage(page.getPages());
        pageResponse.setItems(page.getRecords().stream().map(function).collect(Collectors.toList()));
        return pageResponse;
    }
}

