/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.mybatisplus.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.wenzuo.atom.core.param.PageRequest;
import net.wenzuo.atom.core.param.PageResponse;
import org.springframework.lang.Nullable;

public abstract class PageUtils {
    @Nullable
    public static <T> Page<T> convert(@Nullable PageRequest source) {
        if (source == null) {
            return null;
        }
        return new Page(source.getPageNumber(), source.getPageSize());
    }

    @Nullable
    public static <T> PageResponse<T> convert(@Nullable Page<T> source) {
        if (source == null) {
            return null;
        }
        PageResponse pageResponse = new PageResponse();
        pageResponse.setPageNumber(source.getCurrent());
        pageResponse.setPageSize(source.getSize());
        pageResponse.setTotalRow(source.getTotal());
        pageResponse.setTotalPage(source.getPages());
        pageResponse.setItems(source.getRecords());
        return pageResponse;
    }

    @Nullable
    public static <T, R> PageResponse<R> convert(@Nullable Page<T> source, Function<T, R> function) {
        if (source == null) {
            return null;
        }
        PageResponse pageResponse = new PageResponse();
        pageResponse.setPageNumber(source.getCurrent());
        pageResponse.setPageSize(source.getSize());
        pageResponse.setTotalRow(source.getTotal());
        pageResponse.setTotalPage(source.getPages());
        pageResponse.setItems(source.getRecords().stream().map(function).collect(Collectors.toList()));
        return pageResponse;
    }
}

