/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.mqtt.config;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.wenzuo.atom.mqtt.MqttConsumer;
import net.wenzuo.atom.mqtt.MqttConsumerProcessor;
import net.wenzuo.atom.mqtt.MqttSubscriber;
import net.wenzuo.atom.mqtt.config.MqttProperties;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;

@ConditionalOnClass(value={MqttClient.class})
@Configuration
public class Mqttv3Configuration
implements ApplicationListener<ApplicationStartedEvent>,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Mqttv3Configuration.class);
    private final MqttProperties mqttProperties;
    private final List<MqttSubscriber> mqttSubscribers;
    @Value(value="${spring.application.name:-atom}")
    private String applicationName;
    @Value(value="${spring.profiles.active:-}")
    private String activeProfile;

    public void onApplicationEvent(@NonNull ApplicationStartedEvent event) {
        List<MqttProperties.MqttInstance> instances = this.mqttProperties.getInstances();
        if (instances == null || instances.isEmpty()) {
            return;
        }
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Map<String, List<MqttConsumer>> consumerMap = MqttConsumerProcessor.processConsumerMap(applicationContext, this.mqttProperties, this.mqttSubscribers);
        for (MqttProperties.MqttInstance instance : instances) {
            if (!instance.getEnabled().booleanValue()) continue;
            try {
                if (StrUtil.isBlank((CharSequence)instance.getClientId())) {
                    String suffix = RandomUtil.randomString((int)6);
                    instance.setClientId(this.applicationName + "-" + this.activeProfile + "-" + suffix);
                }
                String[] urls = instance.getUrl().split(",");
                MqttClient mqttClient = new MqttClient(urls[0], instance.getClientId(), (MqttClientPersistence)new MemoryPersistence());
                MqttConnectOptions options = new MqttConnectOptions();
                options.setServerURIs(urls);
                if (instance.getUsername() != null) {
                    options.setUserName(instance.getUsername());
                }
                if (instance.getPassword() != null) {
                    options.setPassword(instance.getPassword().toCharArray());
                }
                options.setAutomaticReconnect(true);
                mqttClient.connect(options);
                beanFactory.registerSingleton("mqttClient-" + instance.getId(), (Object)mqttClient);
                List<MqttConsumer> consumers = consumerMap.get(instance.getId());
                if (consumers == null || consumers.isEmpty()) continue;
                for (MqttConsumer consumer : consumers) {
                    String[] topics = consumer.getTopics();
                    if (topics == null || topics.length == 0) continue;
                    int[] qos = consumer.getQos();
                    IMqttMessageListener[] listeners = new IMqttMessageListener[topics.length];
                    for (int i = 0; i < topics.length; ++i) {
                        listeners[i] = (topic, message) -> consumer.getConsumer().accept(topic, new String(message.getPayload(), StandardCharsets.UTF_8));
                    }
                    mqttClient.subscribe(topics, qos, listeners);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("MQTT connect error: " + e.getMessage(), e);
            }
        }
    }

    public int getOrder() {
        return this.mqttProperties.getOrder();
    }

    @Generated
    public Mqttv3Configuration(MqttProperties mqttProperties, List<MqttSubscriber> mqttSubscribers) {
        this.mqttProperties = mqttProperties;
        this.mqttSubscribers = mqttSubscribers;
    }
}

