/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.mqtt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.wenzuo.atom.mqtt.MqttConsumer;
import net.wenzuo.atom.mqtt.MqttListenerProcessor;
import net.wenzuo.atom.mqtt.MqttSubscriber;
import net.wenzuo.atom.mqtt.config.MqttProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class MqttConsumerProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttConsumerProcessor.class);

    public static Map<String, List<MqttConsumer>> processConsumerMap(ConfigurableApplicationContext applicationContext, MqttProperties properties, List<MqttSubscriber> subscribers) {
        HashMap<String, List<MqttConsumer>> consumerMap = new HashMap<String, List<MqttConsumer>>();
        MqttConsumerProcessor.processListener(consumerMap, applicationContext, properties);
        MqttConsumerProcessor.processSubscriber(consumerMap, subscribers, properties);
        return consumerMap;
    }

    private static void processListener(Map<String, List<MqttConsumer>> consumerMap, ConfigurableApplicationContext applicationContext, MqttProperties properties) {
        MqttListenerProcessor mqttListenerProcessor = (MqttListenerProcessor)applicationContext.getBean(MqttListenerProcessor.class);
        List<MqttConsumer> consumers = mqttListenerProcessor.getConsumers();
        if (consumers == null || consumers.isEmpty()) {
            return;
        }
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        BeanExpressionContext expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null);
        BeanExpressionResolver expressionResolver = beanFactory.getBeanExpressionResolver();
        for (MqttConsumer consumer : consumers) {
            String id = consumer.getId();
            if (id == null || id.isEmpty()) {
                consumer.setId(properties.getId());
            }
            String[] topics = MqttConsumerProcessor.processExpression(consumer.getTopics(), beanFactory, expressionContext, expressionResolver);
            consumer.setTopics(topics);
            consumer.initialize();
            List list = consumerMap.computeIfAbsent(consumer.getId(), k -> new ArrayList());
            list.add(consumer);
        }
    }

    private static String[] processExpression(String[] topics, ConfigurableListableBeanFactory beanFactory, BeanExpressionContext expressionContext, BeanExpressionResolver expressionResolver) {
        if (topics == null || topics.length == 0) {
            return null;
        }
        if (expressionResolver != null) {
            ArrayList<String> newTopics = new ArrayList<String>();
            for (String topic : topics) {
                Object object = expressionResolver.evaluate(beanFactory.resolveEmbeddedValue(topic), expressionContext);
                if (object == null) {
                    throw new IllegalArgumentException("MQTT topic must not be null");
                }
                if (object instanceof String) {
                    String str = (String)object;
                    newTopics.add(str);
                    continue;
                }
                if (object instanceof String[]) {
                    String[] strs;
                    for (String str : strs = (String[])object) {
                        if (str == null) {
                            throw new IllegalArgumentException("MQTT topic must not be null");
                        }
                        newTopics.add(str);
                    }
                    continue;
                }
                throw new IllegalArgumentException("MQTT topic must be String or String[]");
            }
            topics = newTopics.toArray(new String[0]);
        }
        return topics;
    }

    private static void processSubscriber(Map<String, List<MqttConsumer>> consumerMap, List<MqttSubscriber> subscribers, MqttProperties properties) {
        if (subscribers == null || subscribers.isEmpty()) {
            return;
        }
        for (MqttSubscriber subscriber : subscribers) {
            String id = subscriber.id();
            if (id == null || id.isEmpty()) {
                id = properties.getId();
            }
            String[] topics = subscriber.topics();
            int[] qos = subscriber.qos();
            MqttConsumer consumer = new MqttConsumer(id, topics, qos, (topic, message) -> {
                try {
                    subscriber.message((String)topic, (String)message);
                }
                catch (Exception e) {
                    log.error("MQTT invoke error", (Throwable)e);
                }
            });
            consumer.initialize();
            List list = consumerMap.computeIfAbsent(id, k -> new ArrayList());
            list.add(consumer);
        }
    }
}

