/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.jwt.service.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import java.text.ParseException;
import java.util.Optional;
import net.wenzuo.atom.core.util.JsonUtils;
import net.wenzuo.atom.jwt.service.JwtService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JwtServiceImpl
implements JwtService {
    private static final Logger log = LoggerFactory.getLogger(JwtServiceImpl.class);
    private final JWSSigner jwsSigner;
    private final JWSVerifier jwsVerifier;

    @Override
    public <T> String sign(T payload) {
        Optional jwsAlgorithm = this.jwsSigner.supportedJWSAlgorithms().stream().findFirst();
        if (jwsAlgorithm.isEmpty()) {
            throw new RuntimeException("JWSAlgorithm is empty");
        }
        JWSHeader jwsHeader = new JWSHeader((JWSAlgorithm)jwsAlgorithm.get());
        JWSObject jwsObject = new JWSObject(jwsHeader, new Payload(JsonUtils.toJson(payload)));
        try {
            jwsObject.sign(this.jwsSigner);
            return jwsObject.serialize();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T parse(String signed, Class<T> clazz) {
        try {
            JWSObject jwsObject = JWSObject.parse((String)signed);
            if (!jwsObject.verify(this.jwsVerifier)) {
                return null;
            }
            if (clazz == String.class) {
                return (T)jwsObject.getPayload().toString();
            }
            return (T)JsonUtils.toObject((String)jwsObject.getPayload().toString(), clazz);
        }
        catch (JOSEException | ParseException e) {
            return null;
        }
    }

    public JwtServiceImpl(JWSSigner jwsSigner, JWSVerifier jwsVerifier) {
        this.jwsSigner = jwsSigner;
        this.jwsVerifier = jwsVerifier;
    }
}

