/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util;

import cn.hutool.core.io.IoUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public abstract class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static ObjectMapper objectMapper = JsonUtils.objectMapper();
    private static PropertyNamingStrategy propertyNamingStrategy = PropertyNamingStrategies.LOWER_CAMEL_CASE;

    public static void setDefaultPropertyNamingStrategy(PropertyNamingStrategy strategy) {
        propertyNamingStrategy = strategy;
        objectMapper = JsonUtils.objectMapper();
    }

    public static <T> String toJson(T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CharSequence) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String toPrettyJson(T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CharSequence) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        try {
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return (T)json;
            }
            return (T)(json == null || json.isEmpty() ? null : objectMapper.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(InputStream inputStream, Class<T> clazz) {
        try {
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return (T)IoUtil.readUtf8((InputStream)inputStream);
            }
            return (T)(inputStream == null ? null : objectMapper.readValue(inputStream, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Class<?> wrapper, Class<?> ... inners) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(wrapper, (Class[])inners);
        try {
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(InputStream inputStream, Class<?> wrapper, Class<?> ... inners) {
        if (inputStream == null) {
            return null;
        }
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(wrapper, (Class[])inners);
        try {
            return (T)objectMapper.readValue(inputStream, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Type type) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        JavaType javaType = objectMapper.getTypeFactory().constructType(type);
        try {
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(InputStream inputStream, Type type) {
        if (inputStream == null) {
            return null;
        }
        JavaType javaType = objectMapper.getTypeFactory().constructType(type);
        try {
            return (T)objectMapper.readValue(inputStream, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> type) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(InputStream inputStream, TypeReference<T> type) {
        if (inputStream == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper objectMapper() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        JsonUtils.customize().customize(builder);
        ObjectMapper objectMapper = new ObjectMapper();
        builder.configure(objectMapper);
        return objectMapper;
    }

    public static Jackson2ObjectMapperBuilderCustomizer customize() {
        String dateFormat = "yyyy-MM-dd";
        String timeFormat = "HH:mm:ss";
        String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
        String timeZone = "GMT+8";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datetimeFormat);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(dateFormat);
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(timeFormat);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(datetimeFormat);
        LocalDateSerializer localDateSerializer = new LocalDateSerializer(dateFormatter);
        LocalDateDeserializer localDateDeserializer = new LocalDateDeserializer(dateFormatter);
        LocalTimeSerializer localTimeSerializer = new LocalTimeSerializer(timeFormatter);
        LocalTimeDeserializer localTimeDeserializer = new LocalTimeDeserializer(timeFormatter);
        LocalDateTimeSerializer localDateTimeSerializer = new LocalDateTimeSerializer(dateTimeFormatter);
        LocalDateTimeDeserializer localDateTimeDeserializer = new LocalDateTimeDeserializer(dateTimeFormatter);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)localDateSerializer).addDeserializer(LocalDate.class, (JsonDeserializer)localDateDeserializer).addSerializer(LocalTime.class, (JsonSerializer)localTimeSerializer).addDeserializer(LocalTime.class, (JsonDeserializer)localTimeDeserializer).addSerializer(LocalDateTime.class, (JsonSerializer)localDateTimeSerializer).addDeserializer(LocalDateTime.class, (JsonDeserializer)localDateTimeDeserializer);
        Jdk8Module jdk8Module = new Jdk8Module();
        ParameterNamesModule parameterNamesModule = new ParameterNamesModule();
        return builder -> builder.locale(Locale.SIMPLIFIED_CHINESE).timeZone(TimeZone.getTimeZone(timeZone)).dateFormat((DateFormat)simpleDateFormat).propertyNamingStrategy(propertyNamingStrategy).serializationInclusion(JsonInclude.Include.ALWAYS).featuresToEnable(new Object[0]).featuresToDisable(new Object[]{SerializationFeature.FAIL_ON_EMPTY_BEANS, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).modules(new Module[]{simpleModule, javaTimeModule, jdk8Module, parameterNamesModule});
    }
}

