/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ValidatorUtils {
    public static final Validator VALIDATOR_FAST;
    public static final Validator VALIDATOR_ALL;

    public static void validate(Validator validator, Object object, Class<?> ... groups) {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    public static void validateProperty(Validator validator, Object object, String propertyName, Class<?> ... groups) {
        Set constraintViolations = validator.validateProperty(object, propertyName, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    public static <T> void validateValue(Validator validator, Class<T> clazz, String propertyName, Object value, Class<?> ... groups) {
        Set constraintViolations = validator.validateValue(clazz, propertyName, value, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    static {
        try (ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory();){
            VALIDATOR_FAST = factory.getValidator();
        }
        factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory();
        try {
            VALIDATOR_ALL = factory.getValidator();
        }
        finally {
            if (factory != null) {
                factory.close();
            }
        }
    }
}

