/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.wenzuo.atom.core.exception.BadRequestException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class Should {
    public static void isEquals(Object a, Object b, String message) {
        if (!Objects.equals(a, b)) {
            throw new BadRequestException(message);
        }
    }

    public static void isEquals(Object a, Object b, Supplier<String> messageSupplier) {
        if (!Objects.equals(a, b)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notEquals(Object a, Object b, String message) {
        if (Objects.equals(a, b)) {
            throw new BadRequestException(message);
        }
    }

    public static void notEquals(Object a, Object b, Supplier<String> messageSupplier) {
        if (Objects.equals(a, b)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new BadRequestException(message);
        }
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new BadRequestException(message);
        }
    }

    public static void isFalse(boolean expression, Supplier<String> messageSupplier) {
        if (expression) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isNull(@Nullable Object object, String message) {
        if (object != null) {
            throw new BadRequestException(message);
        }
    }

    public static void isNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notNull(@Nullable Object object, String message) {
        if (object == null) {
            throw new BadRequestException(message);
        }
    }

    public static void notNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isEmpty(@Nullable String text, String message) {
        if (text != null && text.length() > 0) {
            throw new BadRequestException(message);
        }
    }

    public static void isEmpty(@Nullable String text, Supplier<String> messageSupplier) {
        if (text != null && text.length() > 0) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(@Nullable String text, String message) {
        if (text == null || text.length() == 0) {
            throw new BadRequestException(message);
        }
    }

    public static void notEmpty(@Nullable String text, Supplier<String> messageSupplier) {
        if (text == null || text.length() == 0) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isBlank(@Nullable String text, String message) {
        if (StringUtils.hasText((String)text)) {
            throw new BadRequestException(message);
        }
    }

    public static void isBlank(@Nullable String text, Supplier<String> messageSupplier) {
        if (StringUtils.hasText((String)text)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notBlank(@Nullable String text, String message) {
        if (!StringUtils.hasText((String)text)) {
            throw new BadRequestException(message);
        }
    }

    public static void notBlank(@Nullable String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasText((String)text)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isContains(@Nullable String textToSearch, String substring, String message) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && !textToSearch.contains(substring)) {
            throw new BadRequestException(message);
        }
    }

    public static void isContains(@Nullable String textToSearch, String substring, Supplier<String> messageSupplier) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && !textToSearch.contains(substring)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notContains(@Nullable String textToSearch, String substring, String message) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && textToSearch.contains(substring)) {
            throw new BadRequestException(message);
        }
    }

    public static void notContains(@Nullable String textToSearch, String substring, Supplier<String> messageSupplier) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && textToSearch.contains(substring)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isEmpty(@Nullable Object[] array, String message) {
        if (array != null && array.length > 0) {
            throw new BadRequestException(message);
        }
    }

    public static void isEmpty(@Nullable Object[] array, Supplier<String> messageSupplier) {
        if (array != null && array.length > 0) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(@Nullable Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new BadRequestException(message);
        }
    }

    public static void notEmpty(@Nullable Object[] array, Supplier<String> messageSupplier) {
        if (array == null || array.length == 0) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(@Nullable Object[] array, String message) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new BadRequestException(message);
            }
        }
    }

    public static void noNullElements(@Nullable Object[] array, Supplier<String> messageSupplier) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new BadRequestException(Should.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void isEmpty(@Nullable Collection<?> collection, String message) {
        if (!CollectionUtils.isEmpty(collection)) {
            throw new BadRequestException(message);
        }
    }

    public static void isEmpty(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (!CollectionUtils.isEmpty(collection)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BadRequestException(message);
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, String message) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new BadRequestException(message);
            }
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new BadRequestException(Should.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> map, String message) {
        if (!CollectionUtils.isEmpty(map)) {
            throw new BadRequestException(message);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> map, Supplier<String> messageSupplier) {
        if (!CollectionUtils.isEmpty(map)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, String message) {
        if (CollectionUtils.isEmpty(map)) {
            throw new BadRequestException(message);
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(map)) {
            throw new BadRequestException(Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(@NonNull Class<?> type, @Nullable Object obj, String message) {
        if (!type.isInstance(obj)) {
            Should.instanceCheckFailed(type, obj, message);
        }
    }

    public static void isInstanceOf(@NonNull Class<?> type, @Nullable Object obj, Supplier<String> messageSupplier) {
        if (!type.isInstance(obj)) {
            Should.instanceCheckFailed(type, obj, Should.nullSafeGet(messageSupplier));
        }
    }

    public static void notInstanceOf(@NonNull Class<?> type, @Nullable Object obj, String message) {
        if (type.isInstance(obj)) {
            Should.instanceCheckFailed(type, obj, message);
        }
    }

    public static void notInstanceOf(@NonNull Class<?> type, @Nullable Object obj, Supplier<String> messageSupplier) {
        if (type.isInstance(obj)) {
            Should.instanceCheckFailed(type, obj, Should.nullSafeGet(messageSupplier));
        }
    }

    public static void isAssignable(@NonNull Class<?> superType, @Nullable Class<?> subType, String message) {
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Should.assignableCheckFailed(superType, subType, message);
        }
    }

    public static void isAssignable(@NonNull Class<?> superType, @Nullable Class<?> subType, Supplier<String> messageSupplier) {
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Should.assignableCheckFailed(superType, subType, Should.nullSafeGet(messageSupplier));
        }
    }

    private static void instanceCheckFailed(Class<?> type, @Nullable Object obj, @Nullable String message) {
        String className = obj != null ? obj.getClass().getName() : "null";
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength((String)message)) {
            if (Should.endsWithSeparator(message)) {
                result = message + " ";
            } else {
                result = Should.messageWithTypeName(message, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + "Object of class [" + className + "] must be an instance of " + type;
        }
        throw new BadRequestException((String)result);
    }

    private static void assignableCheckFailed(Class<?> superType, @Nullable Class<?> subType, @Nullable String message) {
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength((String)message)) {
            if (Should.endsWithSeparator(message)) {
                result = message + " ";
            } else {
                result = Should.messageWithTypeName(message, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + subType + " is not assignable to " + superType;
        }
        throw new BadRequestException((String)result);
    }

    private static boolean endsWithSeparator(String message) {
        return message.endsWith(":") || message.endsWith(";") || message.endsWith(",") || message.endsWith(".");
    }

    private static String messageWithTypeName(String message, @Nullable Object typeName) {
        return message + (message.endsWith(" ") ? "" : ": ") + typeName;
    }

    @Nullable
    private static String nullSafeGet(@Nullable Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

