/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.config;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import net.wenzuo.atom.core.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@ConditionalOnProperty(value={"atom.core.async"}, matchIfMissing=true)
@Configuration
public class CoreAsyncConfiguration
implements AsyncConfigurer,
AsyncUncaughtExceptionHandler,
TaskDecorator {
    private static final Logger log = LoggerFactory.getLogger(CoreAsyncConfiguration.class);
    private final TaskExecutionProperties taskExecutionProperties;

    public Executor getAsyncExecutor() {
        TaskExecutionProperties.Pool pool = this.taskExecutionProperties.getPool();
        TaskExecutionProperties.Shutdown shutdown = this.taskExecutionProperties.getShutdown();
        ThreadPoolTaskExecutor executor = new TaskExecutorBuilder().queueCapacity(pool.getQueueCapacity()).corePoolSize(pool.getCoreSize()).maxPoolSize(pool.getMaxSize()).allowCoreThreadTimeOut(pool.isAllowCoreThreadTimeout()).keepAlive(pool.getKeepAlive()).awaitTermination(shutdown.isAwaitTermination()).awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod()).threadNamePrefix(this.taskExecutionProperties.getThreadNamePrefix()).taskDecorator((TaskDecorator)this).build();
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return this;
    }

    public void handleUncaughtException(Throwable t, Method method, Object ... params) {
        String message = "async exception: " + t.getMessage() + ", method: " + method.getName() + ", params: " + JsonUtils.toJson(params);
        log.error(message, t);
    }

    @NonNull
    public Runnable decorate(@NonNull Runnable runnable) {
        Map contextMap = MDC.getCopyOfContextMap();
        return () -> {
            try {
                if (contextMap != null) {
                    MDC.setContextMap((Map)contextMap);
                }
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    public CoreAsyncConfiguration(TaskExecutionProperties taskExecutionProperties) {
        this.taskExecutionProperties = taskExecutionProperties;
    }
}

