/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.utils;

import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ValidatorUtils {
    public static final Validator VALIDATOR_FAST;
    public static final Validator VALIDATOR_ALL;

    public static void validate(Validator validator, Object object, Class<?> ... groups) {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    public static void validateProperty(Validator validator, Object object, String propertyName, Class<?> ... groups) {
        Set constraintViolations = validator.validateProperty(object, propertyName, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    public static <T> void validateValue(Validator validator, Class<T> clazz, String propertyName, Object value, Class<?> ... groups) {
        Set constraintViolations = validator.validateValue(clazz, propertyName, value, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    static {
        try (ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory();){
            VALIDATOR_FAST = factory.getValidator();
        }
        factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory();
        var1_1 = null;
        try {
            VALIDATOR_ALL = factory.getValidator();
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (factory != null) {
                if (var1_1 != null) {
                    try {
                        factory.close();
                    }
                    catch (Throwable throwable) {
                        var1_1.addSuppressed(throwable);
                    }
                } else {
                    factory.close();
                }
            }
        }
    }
}

