/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.api.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.wenzuo.atom.api.validator.AnyOfEnum;

public class AnyOfEnumValidator
implements ConstraintValidator<AnyOfEnum, Enum<?>> {
    private Set<Enum<?>> accepts;

    public void initialize(AnyOfEnum annotation) {
        Enum<?>[] enums = annotation.value().getEnumConstants();
        this.accepts = Stream.of(enums).collect(Collectors.toSet());
    }

    public boolean isValid(Enum<?> value, ConstraintValidatorContext context) {
        return value == null || this.accepts.contains(value);
    }
}

