/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryStream;
import cascading.tuple.TupleStream;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import data.InputData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.junit.Test;

public class TapStreamPlatformTest
extends PlatformTestCase {
    public TapStreamPlatformTest() {
        super(false);
    }

    @Test
    public void testFlowStream() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        Tap source = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        Pipe pipe = new Pipe("test");
        Tap sink = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), ",", this.getOutputPath(), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        int sum = flow.getSinkEntryStream().mapToInt(TupleEntryStream.fieldToInt((Fields)Fields.FIRST)).sum();
        TapStreamPlatformTest.assertEquals((int)210, (int)sum);
    }

    @Test
    public void testTupleEntryStream() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        FlowProcess flowProcess = this.getPlatform().getFlowProcess();
        Tap tap = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        long count = TupleEntryStream.entryStream(tap, flowProcess).count();
        TapStreamPlatformTest.assertEquals((long)20L, (long)count);
        int sum = TupleEntryStream.entryStream(tap, flowProcess).mapToInt(TupleEntryStream.fieldToInt((Fields)Fields.FIRST)).sum();
        TapStreamPlatformTest.assertEquals((int)210, (int)sum);
        List collect1 = TupleEntryStream.entryStream(tap, flowProcess).map(TupleEntryStream.fieldToObject((Fields)Fields.FIRST)).collect(Collectors.toList());
        TapStreamPlatformTest.assertEquals((int)20, (int)collect1.size());
        List collect2 = TupleEntryStream.entryStream(tap, flowProcess).map(TupleEntryStream.fieldToObject((Fields)Fields.FIRST, Integer.class)).collect(Collectors.toList());
        TapStreamPlatformTest.assertEquals((int)20, (int)collect2.size());
        List collect3 = TupleEntryStream.entryStream(tap, flowProcess).map(TupleEntryStream.fieldToObject((Fields)Fields.FIRST, (CoercibleType)Coercions.INTEGER_OBJECT)).collect(Collectors.toList());
        TapStreamPlatformTest.assertEquals((int)20, (int)collect3.size());
        Set collect4 = TupleEntryStream.entryStream(tap, flowProcess).collect(Collectors.toSet());
        TapStreamPlatformTest.assertEquals((int)1, (int)new HashSet(collect4).size());
        Set collect5 = TupleEntryStream.entryStreamCopy(tap, flowProcess).collect(Collectors.toSet());
        TapStreamPlatformTest.assertEquals((int)20, (int)new HashSet(collect5).size());
    }

    @Test
    public void testTupleStream() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        FlowProcess flowProcess = this.getPlatform().getFlowProcess();
        Tap tap = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        long count = TupleStream.tupleStream(tap, flowProcess).count();
        TapStreamPlatformTest.assertEquals((long)20L, (long)count);
        int sum = TupleStream.tupleStream(tap, flowProcess).mapToInt(TupleStream.posToInt((int)0)).sum();
        TapStreamPlatformTest.assertEquals((int)210, (int)sum);
        List collect1 = TupleStream.tupleStream(tap, flowProcess).map(TupleStream.posToObject((int)0)).collect(Collectors.toList());
        TapStreamPlatformTest.assertEquals((int)20, (int)collect1.size());
        Set collect2 = TupleStream.tupleStream(tap, flowProcess).collect(Collectors.toSet());
        TapStreamPlatformTest.assertEquals((int)1, (int)new HashSet(collect2).size());
        Set collect3 = TupleStream.tupleStreamCopy(tap, flowProcess).collect(Collectors.toSet());
        TapStreamPlatformTest.assertEquals((int)20, (int)new HashSet(collect3).size());
    }

    @Test
    public void testTupleEntryWriter() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        FlowProcess flowProcess = this.getPlatform().getFlowProcess();
        Tap source = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", this.getOutputPath());
        Stream stream = TupleEntryStream.entryStream(source, flowProcess);
        Tap result = TupleEntryStream.writeEntry(stream::iterator, sink, flowProcess);
        TapStreamPlatformTest.assertEquals((long)20L, (long)TupleEntryStream.entryStream((Tap)result, flowProcess).count());
    }

    @Test
    public void testTupleEntryTupleWriter() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        FlowProcess flowProcess = this.getPlatform().getFlowProcess();
        Tap source = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", this.getOutputPath());
        Stream<Tuple> stream = TupleEntryStream.entryStream(source, flowProcess).map(entry -> entry.selectTuple(new Fields(new Comparable[]{"num"})));
        Tap result = TupleStream.writeTuple(stream, sink, flowProcess);
        TapStreamPlatformTest.assertEquals((long)20L, (long)TupleEntryStream.entryStream((Tap)result, flowProcess).count());
    }

    @Test
    public void testTupleEntryIntWriter() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        FlowProcess flowProcess = this.getPlatform().getFlowProcess();
        Tap source = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", this.getOutputPath());
        IntStream stream = TupleEntryStream.entryStream(source, flowProcess).mapToInt(TupleEntryStream.fieldToInt((Fields)new Fields(new Comparable[]{"num"})));
        Tap result = TupleStream.writeInt((IntStream)stream, sink, flowProcess);
        TapStreamPlatformTest.assertEquals((long)20L, (long)TupleEntryStream.entryStream((Tap)result, flowProcess).count());
    }

    @Test
    public void testTupleEntryLongWriter() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        FlowProcess flowProcess = this.getPlatform().getFlowProcess();
        Tap source = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", this.getOutputPath());
        LongStream stream = TupleEntryStream.entryStream(source, flowProcess).mapToLong(TupleEntryStream.fieldToLong((Fields)new Fields(new Comparable[]{"num"})));
        Tap result = TupleStream.writeLong((LongStream)stream, sink, flowProcess);
        TapStreamPlatformTest.assertEquals((long)20L, (long)TupleEntryStream.entryStream((Tap)result, flowProcess).count());
    }

    @Test
    public void testTupleEntryDoubleWriter() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        FlowProcess flowProcess = this.getPlatform().getFlowProcess();
        Tap source = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", InputData.inputFileNums20);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields((Comparable)((Object)"num"), Integer.class), " ", this.getOutputPath());
        DoubleStream stream = TupleEntryStream.entryStream(source, flowProcess).mapToDouble(TupleEntryStream.fieldToDouble((Fields)new Fields(new Comparable[]{"num"})));
        Tap result = TupleStream.writeDouble((DoubleStream)stream, sink, flowProcess);
        TapStreamPlatformTest.assertEquals((long)20L, (long)TupleEntryStream.entryStream((Tap)result, flowProcess).count());
    }
}

