/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.PlatformTestCase;
import cascading.TestBuffer;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.FlowTapException;
import cascading.operation.Buffer;
import cascading.operation.Debug;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.operation.regex.RegexSplitter;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.MultiSinkTap;
import cascading.tap.MultiSourceTap;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.partition.DelimitedPartition;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeIteratorProps;
import data.InputData;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Test;

public class TapPlatformTest
extends PlatformTestCase
implements Serializable {
    public TapPlatformTest() {
        super(true, 4, 1);
    }

    @Test
    public void testSinkDeclaredFields() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileCross);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileCross);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new RegexSplitter(new Fields(new Comparable[]{"first", "second", "third"}), "\\s"), Fields.ALL);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), new Fields(new Comparable[]{"second", "first", "third"}), this.getOutputPath("declaredsinks"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        TapPlatformTest.validateLength((Flow)flow, (int)37, null);
        TupleEntryIterator iterator = flow.openSink();
        String line = ((TupleEntry)iterator.next()).getString((Comparable)Integer.valueOf(0));
        TapPlatformTest.assertTrue((String)"not equal: wrong values", (boolean)line.matches("[a-z]\t[0-9]\t[A-Z]"));
        iterator.close();
    }

    @Test
    public void testSinkUnknown() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileCross);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileCross);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new RegexSplitter(new Fields(new Comparable[]{"first", "second", "third"}), "\\s"), Fields.RESULTS);
        Tap sink = this.getPlatform().getTabDelimitedFile(Fields.UNKNOWN, this.getOutputPath("unknownsinks"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        TapPlatformTest.validateLength((Flow)flow, (int)37, null);
        TupleEntryIterator iterator = flow.openSink();
        String line = ((TupleEntry)iterator.next()).getTuple().toString();
        TapPlatformTest.assertTrue((String)("not equal: wrong values: " + line), (boolean)line.matches("[0-9]\t[a-z]\t[A-Z]"));
        iterator.close();
    }

    @Test
    public void testMultiSinkTap() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileJoined);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileJoined);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new RegexSplitter(new Fields(new Comparable[]{"number", "lower", "upper"}), "\t"));
        Tap lhsSink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), new Fields(new Comparable[]{"number", "lower"}), this.getOutputPath("multisink/lhs"), SinkMode.REPLACE);
        Tap rhsSink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), new Fields(new Comparable[]{"number", "upper"}), this.getOutputPath("multisink/rhs"), SinkMode.REPLACE);
        MultiSinkTap sink = new MultiSinkTap(new Tap[]{lhsSink, rhsSink});
        Flow flow = this.getPlatform().getFlowConnector().connect(source, (Tap)sink, pipe);
        flow.complete();
        TapPlatformTest.validateLength((TupleEntryIterator)flow.openTapForRead(lhsSink), (int)5);
        TapPlatformTest.validateLength((TupleEntryIterator)flow.openTapForRead(rhsSink), (int)5);
    }

    @Test
    public void testMultiSourceIterator() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileUpper);
        MultiSourceTap source = new MultiSourceTap(new Tap[]{sourceLower, sourceUpper});
        TapPlatformTest.validateLength((TupleEntryIterator)source.openForRead(this.getPlatform().getFlowProcess()), (int)10);
    }

    @Test
    public void testSideFileCollector() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLhs);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileLhs);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("sidefile/direct"), SinkMode.REPLACE);
        Tap sideFile = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("sidefile/indirect"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower"}), "\\s"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"num"}));
        pipe = new Every(pipe, (Buffer)new TestBuffer(sideFile, new Fields(new Comparable[]{"next"}), 2, true, true, "next"));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        TapPlatformTest.validateLength((Flow)flow, (int)23, null);
        List results = TapPlatformTest.getSinkAsList((Flow)flow);
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tnull\tnext"})));
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\ta\tnext"})));
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tb\tnext"})));
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tc\tnext"})));
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tnull\tnext"})));
        results = TapPlatformTest.asList((Flow)flow, (Tap)sideFile);
        TapPlatformTest.assertEquals((int)13, (int)results.size());
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\ta"})));
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tb"})));
        TapPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tc"})));
    }

    @Test
    public void testPartitionTapTextDelimited() throws IOException {
        this.runPartitionTest("");
    }

    @Test
    public void testPartitionTapTextDelimitedPostFix() throws IOException {
        this.runPartitionTest("/somepath/filename.txt");
    }

    private void runPartitionTest(String postfix) throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileCrossX2);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower", "upper"}), " ", InputData.inputFileCrossX2);
        Tap partitionTap = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned"), SinkMode.REPLACE);
        DelimitedPartition partition = new DelimitedPartition(new Fields(new Comparable[]{"lower", "number"}), "/", postfix);
        partitionTap = this.getPlatform().getPartitionTap(partitionTap, (Partition)partition, 1);
        Flow firstFlow = this.getPlatform().getFlowConnector().connect(source, partitionTap, new Pipe("partition"));
        firstFlow.complete();
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower", "upper"}), "+", this.getOutputPath("/final"), SinkMode.REPLACE);
        Flow secondFlow = this.getPlatform().getFlowConnector().connect(partitionTap, sink, new Pipe("copy"));
        secondFlow.complete();
        Tap test = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), partitionTap.getIdentifier().toString() + "/a/1" + postfix);
        TapPlatformTest.validateLength((TupleEntryIterator)firstFlow.openTapForRead(test), (int)6, (Pattern)Pattern.compile("[A-Z]"));
        test = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), partitionTap.getIdentifier().toString() + "/b/2" + postfix);
        TapPlatformTest.validateLength((TupleEntryIterator)firstFlow.openTapForRead(test), (int)6, (Pattern)Pattern.compile("[A-Z]"));
        List tuples = TapPlatformTest.asList((Flow)firstFlow, (Tap)partitionTap);
        TapPlatformTest.assertEquals((int)2, (int)Collections.frequency(tuples, new Tuple(new Object[]{"A", "a", "1"})));
        TapPlatformTest.assertEquals((int)2, (int)Collections.frequency(tuples, new Tuple(new Object[]{"B", "b", "2"})));
        test = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), sink.getIdentifier());
        TapPlatformTest.validateLength((TupleEntryIterator)secondFlow.openTapForRead(test), (int)74, (Pattern)Pattern.compile("[0-9]\\+[a-z]\\+[A-Z]"));
    }

    @Test
    public void testTupleEntrySchemeIteratorExceptionHandling() throws IOException {
        if (this.getPlatformName().equals("local")) {
            return;
        }
        this.getPlatform().copyFromLocal(InputData.inputFileUnexpectedEndOfFile);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileUnexpectedEndOfFile);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath(this.getTestName()), SinkMode.REPLACE);
        Map<Object, Object> properties = this.getProperties();
        TupleEntrySchemeIteratorProps.setPermittedExceptions(properties, (Class[])new Class[]{EOFException.class});
        Pipe pipe = new Pipe("data");
        pipe = new Each(pipe, (Function)new Identity());
        FlowDef flowDef = FlowDef.flowDef().addSource(pipe, source).addTailSink(pipe, sink);
        Flow flow = this.getPlatform().getFlowConnector(properties).connect(flowDef);
        flow.complete();
        TapPlatformTest.validateLength((TupleEntryIterator)flow.openSink(), (int)307);
    }

    @Test
    public void testTupleEntrySchemeIteratorEOFException() throws IOException {
        if (this.getPlatformName().equals("local")) {
            return;
        }
        this.getPlatform().copyFromLocal(InputData.inputFileUnexpectedEndOfFile);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileUnexpectedEndOfFile);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath(this.getTestName()), SinkMode.REPLACE);
        Pipe pipe = new Pipe("data");
        pipe = new Each(pipe, (Function)new Identity());
        FlowDef flowDef = FlowDef.flowDef().addSource(pipe, source).addTailSink(pipe, sink);
        Flow flow = this.getPlatform().getFlowConnector().connect(flowDef);
        try {
            flow.complete();
            TapPlatformTest.fail((String)"flow should have thrown an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(expected=FlowTapException.class)
    public void testTapKeep() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileCrossX2);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower", "upper"}), " ", InputData.inputFileCrossX2);
        String outputPath = this.getOutputPath("/sink");
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", outputPath, SinkMode.REPLACE);
        Flow firstFlow = this.getPlatform().getFlowConnector().connect("first", source, sink, new Pipe("head"));
        firstFlow.complete();
        sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", outputPath, SinkMode.KEEP);
        Flow secondFlow = this.getPlatform().getFlowConnector().connect("second", source, sink, (Pipe)new Each(new Pipe("head"), (Filter)new Debug()));
        secondFlow.complete();
    }

    @Test(expected=FlowTapException.class)
    public void testPartitionTapKeep() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileCrossX2);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower", "upper"}), " ", InputData.inputFileCrossX2);
        String outputPath = this.getOutputPath("/partitioned");
        Tap partitionTap = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", outputPath, SinkMode.REPLACE);
        DelimitedPartition partition = new DelimitedPartition(new Fields(new Comparable[]{"lower", "number"}));
        partitionTap = this.getPlatform().getPartitionTap(partitionTap, (Partition)partition, 1);
        Flow firstFlow = this.getPlatform().getFlowConnector().connect("first", source, partitionTap, new Pipe("partition"));
        firstFlow.complete();
        partitionTap = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", outputPath, SinkMode.KEEP);
        partitionTap = this.getPlatform().getPartitionTap(partitionTap, (Partition)partition, 1);
        Flow secondFlow = this.getPlatform().getFlowConnector().connect("second", source, partitionTap, new Pipe("partition"));
        secondFlow.complete();
    }

    @Test
    public void testPartitionTapMultiSource() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileCrossX2VarLen);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower", "upper"}), " ", InputData.inputFileCrossX2VarLen);
        Tap sinkPartitionTap = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned"), SinkMode.REPLACE);
        DelimitedPartition sinkPartition = new DelimitedPartition(new Fields(new Comparable[]{"lower", "upper", "number"}));
        sinkPartitionTap = this.getPlatform().getPartitionTap(sinkPartitionTap, (Partition)sinkPartition, 1);
        Flow firstFlow = this.getPlatform().getFlowConnector().connect(source, sinkPartitionTap, new Pipe("partition"));
        firstFlow.complete();
        DelimitedPartition sourcePartition = new DelimitedPartition(new Fields(new Comparable[]{"upper", "number"}));
        ArrayList<Tap> taps = new ArrayList<Tap>();
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/a")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/aa")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/aaa")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/b")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/bb")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/bbb")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/c")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/cc")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/ccc")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/d")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/dd")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/ddd")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/e")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/ee")), (Partition)sourcePartition, 1));
        taps.add(this.getPlatform().getPartitionTap(this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"upper"}), "+", this.getOutputPath("/partitioned/eee")), (Partition)sourcePartition, 1));
        MultiSourceTap multiSourceTap = new MultiSourceTap(taps.toArray(new Tap[taps.size()]));
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "upper"}), "+", this.getOutputPath("/final"), SinkMode.REPLACE);
        Flow secondFlow = this.getPlatform().getFlowConnector().connect((Tap)multiSourceTap, sink, new Pipe("copy"));
        secondFlow.complete();
        List tuples = TapPlatformTest.asList((Flow)secondFlow, (Tap)multiSourceTap);
        TapPlatformTest.assertEquals((int)6, (int)Collections.frequency(tuples, new Tuple(new Object[]{"A", "1"})));
        TapPlatformTest.assertEquals((int)6, (int)Collections.frequency(tuples, new Tuple(new Object[]{"B", "1"})));
        TapPlatformTest.assertEquals((int)6, (int)Collections.frequency(tuples, new Tuple(new Object[]{"B", "2"})));
    }
}

