/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.PlatformTestCase;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import org.junit.Test;

public class TapCollectorPlatformTest
extends PlatformTestCase {
    @Test
    public void testTapCollectorText() throws IOException {
        Tap tap = this.getPlatform().getTextFile(this.getOutputPath("tapcollectortext"));
        this.runTest(tap);
    }

    @Test
    public void testTapCollectorSequence() throws IOException {
        Tap tap = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"string", "value", "number"}), "\t", this.getOutputPath("tapcollectorseq"));
        this.runTest(tap);
    }

    private void runTest(Tap tap) throws IOException {
        TupleEntryCollector collector = tap.openForWrite(this.getPlatform().getFlowProcess());
        for (int i = 0; i < 100; ++i) {
            collector.add(new Tuple(new Object[]{"string", "" + i, i}));
        }
        collector.close();
        TupleEntryIterator iterator = tap.openForRead(this.getPlatform().getFlowProcess());
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        iterator.close();
        TapCollectorPlatformTest.assertEquals((String)"wrong size", (int)100, (int)count);
    }
}

