/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.PlatformTestCase;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.flow.Flow;
import cascading.flow.FlowConnector;
import cascading.flow.FlowRuntimeProps;
import cascading.flow.SliceCounters;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.regex.RegexParser;
import cascading.operation.regex.RegexSplitter;
import cascading.operation.state.Counter;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.pipe.Pipe;
import cascading.stats.CascadeStats;
import cascading.stats.FlowStats;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import data.InputData;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.Test;

public class CascadingStatsPlatformTest
extends PlatformTestCase {
    public CascadingStatsPlatformTest() {
        super(true);
    }

    @Test
    public void testStatsCounters() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("first");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.SECOND));
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("flowstats1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("flowstats2"), SinkMode.REPLACE);
        Properties properties = this.getProperties();
        properties = FlowRuntimeProps.flowRuntimeProps().addLogCounter((Enum)SliceCounters.Tuples_Read).buildProperties(properties);
        FlowConnector flowConnector = this.getPlatform().getFlowConnector(properties);
        Flow flow1 = flowConnector.connect("stats1 test", source, sink1, pipe);
        Flow flow2 = flowConnector.connect("stats2 test", source, sink2, pipe);
        Cascade cascade = new CascadeConnector(this.getProperties()).connect(new Flow[]{flow1, flow2});
        cascade.complete();
        CascadeStats cascadeStats = cascade.getCascadeStats();
        CascadingStatsPlatformTest.assertNotNull((Object)cascadeStats.getID());
        CascadingStatsPlatformTest.assertEquals((int)2, (int)cascadeStats.getCountersFor(TestEnum.class.getName()).size());
        CascadingStatsPlatformTest.assertEquals((int)2, (int)cascadeStats.getCountersFor(TestEnum.class).size());
        CascadingStatsPlatformTest.assertEquals((long)40L, (long)cascadeStats.getCounterValue((Enum)TestEnum.FIRST));
        CascadingStatsPlatformTest.assertEquals((long)20L, (long)cascadeStats.getCounterValue((Enum)TestEnum.SECOND));
        CascadingStatsPlatformTest.assertEquals((long)0L, (long)cascadeStats.getCounterValue((Enum)TestEnum.THIRD));
        CascadingStatsPlatformTest.assertEquals((long)0L, (long)cascadeStats.getCounterValue("FOO", "BAR"));
        FlowStats flowStats1 = flow1.getFlowStats();
        CascadingStatsPlatformTest.assertNotNull((Object)flowStats1.getID());
        CascadingStatsPlatformTest.assertEquals((long)20L, (long)flowStats1.getCounterValue((Enum)TestEnum.FIRST));
        CascadingStatsPlatformTest.assertEquals((long)10L, (long)flowStats1.getCounterValue((Enum)TestEnum.SECOND));
        CascadingStatsPlatformTest.assertEquals((long)0L, (long)flowStats1.getCounterValue((Enum)TestEnum.THIRD));
        CascadingStatsPlatformTest.assertEquals((long)0L, (long)flowStats1.getCounterValue("FOO", "BAR"));
        FlowStats flowStats2 = flow2.getFlowStats();
        CascadingStatsPlatformTest.assertNotNull((Object)flowStats2.getID());
        CascadingStatsPlatformTest.assertEquals((long)20L, (long)flowStats2.getCounterValue((Enum)TestEnum.FIRST));
        CascadingStatsPlatformTest.assertEquals((long)10L, (long)flowStats2.getCounterValue((Enum)TestEnum.SECOND));
        cascadeStats.captureDetail();
    }

    @Test
    public void testStatsOnJoin() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileUpper);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("join"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        pipeLower = new Each((Pipe)pipeLower, (Filter)new Counter((Enum)TestEnum.FIRST));
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        pipeUpper = new Each((Pipe)pipeUpper, (Filter)new Counter((Enum)TestEnum.SECOND));
        HashJoin splice = new HashJoin((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), Fields.size((int)4));
        Map<Object, Object> properties = this.getProperties();
        Flow flow = this.getPlatform().getFlowConnector(properties).connect(sources, sink, (Pipe)splice);
        flow.complete();
        CascadingStatsPlatformTest.validateLength((Flow)flow, (int)5);
        FlowStats flowStats = flow.getFlowStats();
        CascadingStatsPlatformTest.assertNotNull((Object)flowStats.getID());
        long firstCounter = flowStats.getCounterValue((Enum)TestEnum.FIRST);
        long secondCounter = flowStats.getCounterValue((Enum)TestEnum.SECOND);
        CascadingStatsPlatformTest.assertEquals((long)5L, (long)firstCounter);
        CascadingStatsPlatformTest.assertNotSame((Object)0, (Object)secondCounter);
        CascadingStatsPlatformTest.assertEquals((long)(firstCounter + secondCounter), (long)flowStats.getCounterValue((Enum)SliceCounters.Tuples_Read));
    }

    static enum TestEnum {
        FIRST,
        SECOND,
        THIRD;

    }
}

