/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.assertion.AssertExpression;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.tap.MultiSinkTap;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.type.DateType;
import data.InputData;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;
import org.junit.Test;

public class TextDelimitedPlatformTest
extends PlatformTestCase {
    @Test
    public void testQuotedText() throws IOException {
        this.runQuotedText("normchar", InputData.testDelimited, ",", false);
    }

    @Test
    public void testQuotedTextAll() throws IOException {
        this.runQuotedText("normchar", InputData.testDelimited, ",", true);
    }

    @Test
    public void testQuotedTextSpecChar() throws IOException {
        this.runQuotedText("specchar", InputData.testDelimitedSpecialCharData, "|", false);
    }

    @Test
    public void testQuotedTextSpecCharAll() throws IOException {
        this.runQuotedText("specchar", InputData.testDelimitedSpecialCharData, "|", true);
    }

    private void runQuotedText(String path, String inputData, String delimiter, boolean useAll) throws IOException {
        Tuple tuple;
        Object[][] results = new Object[][]{{"foo", "bar", "baz", "bin", 1L}, {"foo", "bar", "baz", "bin", 2L}, {"foo", "bar" + delimiter + "bar", "baz", "bin", 3L}, {"foo", "bar\"" + delimiter + "bar", "baz", "bin", 4L}, {"foo", "bar\"\"" + delimiter + "bar", "baz", "bin", 5L}, {null, null, "baz", null, 6L}, {null, null, null, null, 7L}, {"foo", null, null, null, 8L}, {null, null, null, null, 9L}, {"f", null, null, null, 10L}, {"f", null, null, ",bin", 11L}, {"f", null, null, "bin,", 11L}};
        if (useAll) {
            for (int i = 0; i < results.length; ++i) {
                Object[] result = results[i];
                for (int j = 0; j < result.length; ++j) {
                    result[j] = result[j] != null ? result[j].toString() : null;
                }
            }
        }
        Tuple[] tuples = new Tuple[results.length];
        for (int i = 0; i < results.length; ++i) {
            tuples[i] = new Tuple(results[i]);
        }
        Class[] types = new Class[]{String.class, String.class, String.class, String.class, Long.TYPE};
        Fields fields = new Fields(new Comparable[]{"first", "second", "third", "fourth", "fifth"});
        if (useAll) {
            types = null;
            fields = Fields.ALL;
        }
        Tap input = this.getPlatform().getDelimitedFile(fields, false, delimiter, "\"", types, inputData, SinkMode.KEEP);
        Tap output = this.getPlatform().getDelimitedFile(fields, false, delimiter, "\"", types, this.getOutputPath("quoted/" + path + "" + useAll), SinkMode.REPLACE);
        Pipe pipe = new Pipe("pipe");
        Flow flow = this.getPlatform().getFlowConnector().connect(input, output, pipe);
        flow.complete();
        TextDelimitedPlatformTest.validateLength((Flow)flow, (int)results.length, (int)5);
        TupleEntryIterator iterator = flow.openSource();
        int count = 0;
        while (iterator.hasNext()) {
            tuple = ((TupleEntry)iterator.next()).getTuple();
            TextDelimitedPlatformTest.assertEquals((Object)tuples[count++], (Object)tuple);
        }
        iterator = flow.openSink();
        count = 0;
        while (iterator.hasNext()) {
            tuple = ((TupleEntry)iterator.next()).getTuple();
            TextDelimitedPlatformTest.assertEquals((Object)tuples[count++], (Object)tuple);
        }
    }

    @Test
    public void testHeader() throws IOException {
        Class[] types = new Class[]{String.class, String.class, String.class, String.class, Long.TYPE};
        Fields fields = new Fields(new Comparable[]{"first", "second", "third", "fourth", "fifth"});
        Tap input = this.getPlatform().getDelimitedFile(fields, true, true, ",", "\"", types, InputData.testDelimited, SinkMode.KEEP);
        Tap output = this.getPlatform().getDelimitedFile(fields, true, true, ",", "\"", types, this.getOutputPath("header"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("pipe");
        Flow flow = this.getPlatform().getFlowConnector().connect(input, output, pipe);
        flow.complete();
        TextDelimitedPlatformTest.validateLength((Flow)flow, (int)11, (int)5);
    }

    @Test
    public void testHeaderAll() throws IOException {
        Fields fields = new Fields(new Comparable[]{"first", "second", "third", "fourth", "fifth"});
        Tap input = this.getPlatform().getDelimitedFile(fields, true, true, ",", "\"", null, InputData.testDelimited, SinkMode.KEEP);
        Tap output = this.getPlatform().getDelimitedFile(Fields.ALL, true, true, ",", "\"", null, this.getOutputPath("headerall"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("pipe");
        Flow flow = this.getPlatform().getFlowConnector().connect(input, output, pipe);
        flow.complete();
        TextDelimitedPlatformTest.validateLength((Flow)flow, (int)11, (int)5);
    }

    @Test
    public void testHeaderFieldsAll() throws IOException {
        Tap input = this.getPlatform().getDelimitedFile(Fields.UNKNOWN, true, true, ",", "\"", null, InputData.testDelimitedHeader, SinkMode.KEEP);
        Tap output1 = this.getPlatform().getDelimitedFile(Fields.ALL, true, true, ",", "\"", null, this.getOutputPath("headerfieldsall1"), SinkMode.REPLACE);
        Tap output2 = this.getPlatform().getDelimitedFile(Fields.ALL, true, true, ",", "\"", null, this.getOutputPath("headerfieldsall2"), SinkMode.REPLACE);
        MultiSinkTap output = new MultiSinkTap(new Tap[]{output1, output2});
        Pipe pipe = new Pipe("pipe");
        Flow flow = this.getPlatform().getFlowConnector().connect(input, (Tap)output, pipe);
        flow.complete();
        Fields fields = new Fields(new Comparable[]{"first", "second", "third", "fourth", "fifth"});
        TupleEntryIterator iterator = flow.openTapForRead(this.getPlatform().getDelimitedFile(fields, true, true, ",", "\"", null, output1.getIdentifier(), SinkMode.REPLACE));
        TextDelimitedPlatformTest.validateLength((TupleEntryIterator)iterator, (int)13, (int)5);
        this.assertHeaders(output1, flow);
        this.assertHeaders(output2, flow);
    }

    private void assertHeaders(Tap output, Flow flow) throws IOException {
        TupleEntryIterator iterator = flow.openTapForRead(this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), output.getIdentifier()));
        TextDelimitedPlatformTest.assertEquals((Object)((TupleEntry)iterator.next()).getObject(0), (Object)"first,second,third,fourth,fifth");
        iterator.close();
    }

    @Test
    public void testStrict() throws IOException {
        Fields fields = new Fields(new Comparable[]{"first", "second", "third", "fourth", "fifth"});
        Tap input = this.getPlatform().getDelimitedFile(fields, false, false, ",", "\"", null, InputData.testDelimitedExtraField, SinkMode.KEEP);
        Tap output = this.getPlatform().getDelimitedFile(fields, false, false, ",", "\"", null, this.getOutputPath("strict-nondeterministic"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("pipe");
        Flow flow = this.getPlatform().getFlowConnector().connect(input, output, pipe);
        try {
            flow.complete();
            TextDelimitedPlatformTest.fail((String)"should fail on too many fields");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testFieldCoercion() throws IOException {
        DateType dateType = new DateType("dd/MMM/yyyy:HH:mm:ss Z", TimeZone.getDefault(), Locale.US);
        Type[] types = new Type[]{String.class, String.class, String.class, dateType, String.class, Integer.TYPE, Long.TYPE, String.class, String.class, String.class};
        Fields fields = new Fields(new Comparable[]{"ip", "client", "user", "date", "request", "code", "bytes", "referrer", "agent", "na"});
        fields = fields.applyTypes(types);
        Tap input = this.getPlatform().getDelimitedFile(fields, true, true, ",", "\"", null, InputData.inputFileApacheClean, SinkMode.KEEP);
        Tap output = this.getPlatform().getDelimitedFile(fields, true, true, ",", "\"", null, this.getOutputPath(this.getTestName()), SinkMode.REPLACE);
        Pipe pipe = new Pipe("pipe");
        pipe = new Each(pipe, new Fields(new Comparable[]{"date"}), AssertionLevel.STRICT, (Assertion)new AssertExpression("date instanceof Long", Object.class));
        Flow flow = this.getPlatform().getFlowConnector().connect(input, output, pipe);
        flow.complete();
        TextDelimitedPlatformTest.validateLength((Flow)flow, (int)9, (int)10);
    }
}

