/*
 * Decompiled with CFR 0.152.
 */
package cascading.property;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.flow.FlowProcessWrapper;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.Insert;
import cascading.operation.OperationCall;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.property.ConfigDef;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import data.InputData;
import java.io.IOException;
import org.junit.Test;

public class ConfigDefPlatformTest
extends PlatformTestCase {
    public ConfigDefPlatformTest() {
        super(true);
    }

    @Test
    public void testPipeConfigDef() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileNums20);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new IterateInsert(new Fields(new Comparable[]{"value"}), this.getPlatform().isDAG()), Fields.ALL);
        pipe.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "pipe-default");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "process-default");
        pipe.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "pipe-default");
        pipe.getConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "pipe-replace");
        pipe.getNodeConfigDef().setProperty(ConfigDef.Mode.REPLACE, "default-node", "node-replace");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "process-default");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "process-replace");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default-node", "process-default");
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("configdef"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        ConfigDefPlatformTest.assertTrue((boolean)flow.resourceExists(sink));
    }

    @Test
    public void testTapSourceConfigDef() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        Scheme scheme = this.getPlatform().getTestConfigDefScheme();
        Tap source = this.getPlatform().getTap(scheme, InputData.inputFileNums20, SinkMode.KEEP);
        source.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "source-default");
        source.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "process-default");
        source.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "source-default");
        source.getConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "source-replace");
        source.getNodeConfigDef().setProperty(ConfigDef.Mode.REPLACE, "default-node", "node-replace");
        source.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "process-default");
        source.getStepConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "process-replace");
        source.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default-node", "process-default");
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new Insert(new Fields(new Comparable[]{"value"}), new Object[]{"nada"}), Fields.ALL);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("tapsourceconfigdef"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        ConfigDefPlatformTest.assertTrue((boolean)flow.resourceExists(sink));
    }

    @Test
    public void testTapSinkConfigDef() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileNums20, SinkMode.KEEP);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new Insert(new Fields(new Comparable[]{"value"}), new Object[]{"nada"}), Fields.ALL);
        Scheme scheme = this.getPlatform().getTestConfigDefScheme();
        Tap sink = this.getPlatform().getTap(scheme, this.getOutputPath("tapsinkconfigdef"), SinkMode.REPLACE);
        sink.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "sink-default");
        sink.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "process-default");
        sink.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "sink-default");
        sink.getConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "sink-replace");
        sink.getNodeConfigDef().setProperty(ConfigDef.Mode.REPLACE, "default-node", "node-replace");
        sink.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "process-default");
        sink.getStepConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "process-replace");
        sink.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default-node", "process-default");
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        ConfigDefPlatformTest.assertTrue((boolean)flow.resourceExists(sink));
    }

    @Test
    public void testSubAssemblyConfigDef() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileNums20);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileNums20);
        Object pipe = new Pipe("test");
        pipe = new ConfigSubAssembly((Pipe)pipe, this.getPlatform().isDAG());
        pipe.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "pipe-default");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default", "process-default");
        pipe.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "pipe-default");
        pipe.getConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "pipe-replace");
        pipe.getNodeConfigDef().setProperty(ConfigDef.Mode.REPLACE, "default-node", "node-replace");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "replace", "process-default");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.REPLACE, "replace", "process-replace");
        pipe.getStepConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "default-node", "process-default");
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("subassembly-configdef"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        ConfigDefPlatformTest.assertTrue((boolean)flow.resourceExists(sink));
    }

    public static class ConfigSubAssembly
    extends SubAssembly {
        public ConfigSubAssembly(Pipe pipe, boolean supportsNodeConfig) {
            super(new Pipe[]{pipe});
            pipe = new Each(pipe, (Function)new IterateInsert(new Fields(new Comparable[]{"value"}), supportsNodeConfig), Fields.ALL);
            this.setTails(new Pipe[]{pipe});
        }
    }

    public static class IterateInsert
    extends BaseOperation
    implements Function {
        private final boolean supportsNodeConfig;

        public IterateInsert(Fields fieldDeclaration, boolean supportsNodeConfig) {
            super(fieldDeclaration);
            this.supportsNodeConfig = supportsNodeConfig;
        }

        public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
            if (!(flowProcess instanceof FlowProcessWrapper)) {
                throw new RuntimeException("not a flow process wrapper");
            }
            if (!"process-default".equals(flowProcess.getProperty("default"))) {
                throw new RuntimeException("not default value");
            }
            if (!"pipe-replace".equals(flowProcess.getProperty("replace"))) {
                throw new RuntimeException("not replaced value");
            }
            if (this.supportsNodeConfig && !"node-replace".equals(flowProcess.getProperty("default-node"))) {
                throw new RuntimeException("not replaced value");
            }
            if (!"process-default".equals((flowProcess = ((FlowProcessWrapper)flowProcess).getDelegate()).getProperty("default"))) {
                throw new RuntimeException("not default value");
            }
            if (!"process-replace".equals(flowProcess.getProperty("replace"))) {
                throw new RuntimeException("not replaced value");
            }
        }

        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            functionCall.getOutputCollector().add(new Tuple(new Object[]{"value"}));
        }

        public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        }
    }
}

