/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform;

import cascading.PlatformTestCase;
import cascading.platform.PlatformSuite;
import cascading.platform.TestPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import junit.framework.Test;
import org.junit.Ignore;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformRunner
extends ParentRunner<Runner> {
    public static final String PLATFORM_INCLUDES = "test.platform.includes";
    public static final String PLATFORM_RESOURCE = "cascading/platform/platform.properties";
    public static final String PLATFORM_CLASSNAME = "platform.classname";
    private static final Logger LOG = LoggerFactory.getLogger(PlatformRunner.class);
    private Set<String> includes = new HashSet<String>();
    private List<Runner> runners;
    static Map<ClassLoader, Set<Class<? extends TestPlatform>>> cache = new WeakHashMap<ClassLoader, Set<Class<? extends TestPlatform>>>();

    public PlatformRunner(Class<PlatformTestCase> testClass) throws Throwable {
        super(testClass);
        this.setIncludes();
        this.makeRunners();
    }

    private void setIncludes() {
        String[] split;
        String includesString = System.getProperty(PLATFORM_INCLUDES);
        if (includesString == null || includesString.isEmpty()) {
            return;
        }
        for (String include : split = includesString.split(",")) {
            this.includes.add(include.trim().toLowerCase());
        }
    }

    public static TestPlatform makeInstance(Class<? extends TestPlatform> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError exception) {
            throw new RuntimeException(exception);
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Runner> makeRunners() throws Throwable {
        Class javaClass = this.getTestClass().getJavaClass();
        this.runners = new ArrayList<Runner>();
        Set<Class<? extends TestPlatform>> classes = this.getPlatformClassesFromAnnotation(javaClass);
        if (classes.isEmpty()) {
            classes = PlatformRunner.getPlatformClassesFromClasspath(javaClass.getClassLoader());
        }
        int count = 0;
        Iterator<Class<? extends TestPlatform>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            this.addPlatform(javaClass, iterator.next(), count++, classes.size());
        }
        return this.runners;
    }

    private Set<Class<? extends TestPlatform>> getPlatformClassesFromAnnotation(Class<?> javaClass) throws Throwable {
        Platform annotation = javaClass.getAnnotation(Platform.class);
        if (annotation == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<Class<? extends TestPlatform>> classes = new LinkedHashSet<Class<? extends TestPlatform>>(Arrays.asList(annotation.value()));
        LOG.info("found {} test platforms from Platform annotation", (Object)classes.size());
        return classes;
    }

    protected static synchronized Set<Class<? extends TestPlatform>> getPlatformClassesFromClasspath(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (cache.containsKey(classLoader)) {
            return cache.get(classLoader);
        }
        LinkedHashSet<Class<? extends TestPlatform>> classes = new LinkedHashSet<Class<? extends TestPlatform>>();
        Properties properties = new Properties();
        LOG.debug("classloader: {}", (Object)classLoader);
        Enumeration<URL> urls = classLoader.getResources(PLATFORM_RESOURCE);
        while (urls.hasMoreElements()) {
            InputStream stream = urls.nextElement().openStream();
            classes.add(PlatformRunner.getPlatformClass(classLoader, properties, stream));
        }
        if (classes.isEmpty()) {
            LOG.warn("no platform tests will be run");
            LOG.warn("did not find {} in the classpath, no {} instances found", (Object)PLATFORM_RESOURCE, (Object)TestPlatform.class.getCanonicalName());
            LOG.warn("add cascading-local, cascading-hadoop, and/or external planner library to the test classpath");
        } else {
            LOG.info("found {} test platforms from classpath", (Object)classes.size());
        }
        cache.put(classLoader, classes);
        return classes;
    }

    private static Class<?> getPlatformClass(ClassLoader classLoader, Properties properties, InputStream stream) throws IOException, ClassNotFoundException {
        if (stream == null) {
            throw new IllegalStateException("platform provider resource not found: cascading/platform/platform.properties");
        }
        properties.load(stream);
        String classname = properties.getProperty(PLATFORM_CLASSNAME);
        if (classname == null) {
            throw new IllegalStateException("platform provider value not found: platform.classname");
        }
        Class<?> type = classLoader.loadClass(classname);
        if (type == null) {
            throw new IllegalStateException("platform provider class not found: " + classname);
        }
        return type;
    }

    private void addPlatform(Class<?> javaClass, Class<? extends TestPlatform> type, int ordinal, int size) throws Throwable {
        if (javaClass.getAnnotation(Ignore.class) != null) {
            LOG.info("ignoring test class: {}", (Object)javaClass.getCanonicalName());
            return;
        }
        TestPlatform testPlatform = PlatformRunner.makeInstance(type);
        if (testPlatform == null) {
            return;
        }
        String platformName = testPlatform.getName();
        if (!this.includes.isEmpty() && !this.includes.contains(platformName.toLowerCase())) {
            LOG.info("ignoring platform: {}", (Object)platformName);
            return;
        }
        LOG.info("adding test: {}, with platform: {}", (Object)javaClass.getName(), (Object)platformName);
        PlatformSuite suiteAnnotation = javaClass.getAnnotation(PlatformSuite.class);
        if (suiteAnnotation != null) {
            this.runners.add((Runner)this.makeSuiteRunner(javaClass, suiteAnnotation.method(), testPlatform));
        } else {
            this.runners.add((Runner)this.makeClassRunner(javaClass, testPlatform, platformName, size != 1));
        }
    }

    private JUnit38ClassRunner makeSuiteRunner(Class<?> javaClass, String suiteMethod, TestPlatform testPlatform) throws Throwable {
        Method method = javaClass.getMethod(suiteMethod, TestPlatform.class);
        return new JUnit38ClassRunner((Test)method.invoke(null, testPlatform));
    }

    private BlockJUnit4ClassRunner makeClassRunner(Class<?> javaClass, final TestPlatform testPlatform, final String platformName, final boolean useName) throws InitializationError {
        return new BlockJUnit4ClassRunner(javaClass){

            protected String getName() {
                if (useName) {
                    return String.format("%s[%s]", super.getName(), platformName);
                }
                return super.getName();
            }

            protected Object createTest() throws Exception {
                PlatformTestCase testCase = (PlatformTestCase)((Object)super.createTest());
                testCase.installPlatform(testPlatform);
                return testCase;
            }
        };
    }

    protected Description describeChild(Runner runner) {
        return runner.getDescription();
    }

    protected void runChild(Runner runner, RunNotifier runNotifier) {
        runner.run(runNotifier);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        for (Runner runner : this.getChildren()) {
            if (!(runner instanceof Filterable)) continue;
            ((Filterable)runner).filter(filter);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Platform {
        public Class<? extends TestPlatform>[] value();
    }
}

