/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.GroupAssertion;
import cascading.operation.assertion.AssertGroupSizeEquals;
import cascading.operation.assertion.AssertMatches;
import cascading.operation.assertion.AssertNotNull;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import org.junit.Test;

public class BuildAssertionsPlatformTest
extends PlatformTestCase {
    @Test
    public void testLoneGroupAssertion() throws Exception {
        Tap source = this.getPlatform().getTextFile("input");
        Tap sink = this.getPlatform().getTextFile("output", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        String regex = "^([^ ]*) +[^ ]* +[^ ]* +\\[([^]]*)\\] +\\\"([^ ]*) ([^ ]*) [^ ]*\\\" ([^ ]*) ([^ ]*).*$";
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip", "time", "method", "event", "status", "size"}), regex, new int[]{1, 2, 3, 4, 5, 6}));
        pipe = new Each(pipe, AssertionLevel.STRICT, (Assertion)new AssertNotNull());
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), AssertionLevel.STRICT, (Assertion)new AssertMatches("^POST"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
        pipe = new Every(pipe, AssertionLevel.STRICT, (GroupAssertion)new AssertGroupSizeEquals(7L));
        try {
            Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
            BuildAssertionsPlatformTest.fail((String)"did not throw lone group assertion error");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

