/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.nested.core.CopySpec;
import cascading.nested.json.JSONCopyAsFunction;
import cascading.nested.json.JSONGetFunction;
import cascading.nested.json.transform.JSONPrimitiveTransforms;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import com.fasterxml.jackson.databind.JsonNode;
import data.InputData;
import java.util.List;
import java.util.function.Function;
import org.junit.Test;

public class JSONNestedPlatformTest
extends PlatformTestCase {
    @Test
    public void testSimpleGroup() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileJSON);
        Tap source = this.getPlatform().getJSONFile(new Fields(new Comparable[]{"json"}), InputData.inputFileJSON);
        Pipe pipe = new Pipe("test");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().include(new String[]{"/_id/$oid", "/borrower", "/project_name", "/approvalfy"})).transform("/approvalfy", (Function)JSONPrimitiveTransforms.TO_STRING);
        pipe = new Each(pipe, new Fields(new Comparable[]{"json"}), (cascading.operation.Function)new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec}), Fields.RESULTS);
        pipe = new Each(pipe, new Fields(new Comparable[]{"result"}), (cascading.operation.Function)new JSONGetFunction(new Fields((Comparable)((Object)"year"), Integer.TYPE), new String[]{"/approvalfy"}), Fields.ALL);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"year"}));
        Tap sink = this.getPlatform().getJSONFile(new Fields(new Comparable[]{"result"}), this.getOutputPath(), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        JSONNestedPlatformTest.validateLength((Flow)flow, (int)20);
        List results = JSONNestedPlatformTest.asList((Flow)flow, (Tap)sink);
        JSONNestedPlatformTest.assertEquals((int)20, (int)results.size());
        boolean allMatch = results.stream().map(tuple -> tuple.getObject(0)).allMatch(node -> node instanceof JsonNode);
        JSONNestedPlatformTest.assertTrue((boolean)allMatch);
    }
}

