/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.PlatformTestCase;
import cascading.flow.planner.PlannerException;
import cascading.operation.Aggregator;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.operation.aggregator.Count;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import org.junit.Test;

public class ResolverExceptionsPlatformTest
extends PlatformTestCase {
    private void verify(Tap source, Tap sink, Pipe pipe) {
        try {
            this.getPlatform().getFlowConnector().connect(source, sink, pipe);
            ResolverExceptionsPlatformTest.fail((String)"no exception thrown");
        }
        catch (Exception exception) {
            ResolverExceptionsPlatformTest.assertTrue((boolean)(exception instanceof PlannerException));
            ResolverExceptionsPlatformTest.assertTrue((boolean)(exception.getCause().getCause() instanceof FieldsResolverException));
        }
    }

    @Test
    public void testSchemeResolver() throws Exception {
        Fields sourceFields = new Fields(new Comparable[]{"first", "second"});
        Tap source = this.getPlatform().getTabDelimitedFile(sourceFields, "input/path", SinkMode.KEEP);
        Fields sinkFields = new Fields(new Comparable[]{"third", "fourth"});
        Tap sink = this.getPlatform().getTabDelimitedFile(sinkFields, "output/path", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        this.verify(source, sink, pipe);
    }

    @Test
    public void testEachArgResolver() throws Exception {
        Fields sourceFields = new Fields(new Comparable[]{"first", "second"});
        Tap source = this.getPlatform().getTabDelimitedFile(sourceFields, "input/path", SinkMode.KEEP);
        Fields sinkFields = new Fields(new Comparable[]{"third", "fourth"});
        Tap sink = this.getPlatform().getTabDelimitedFile(sinkFields, "output/path", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"third"}), (Function)new Identity());
        this.verify(source, sink, pipe);
    }

    @Test
    public void testEachOutResolver() throws Exception {
        Fields sourceFields = new Fields(new Comparable[]{"first", "second"});
        Tap source = this.getPlatform().getTabDelimitedFile(sourceFields, "input/path", SinkMode.KEEP);
        Fields sinkFields = new Fields(new Comparable[]{"third", "fourth"});
        Tap sink = this.getPlatform().getTabDelimitedFile(sinkFields, "output/path", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"first"}), (Function)new Identity(new Fields(new Comparable[]{"none"})), new Fields(new Comparable[]{"third"}));
        this.verify(source, sink, pipe);
    }

    @Test
    public void testGroupByResolver() throws Exception {
        Fields sourceFields = new Fields(new Comparable[]{"first", "second"});
        Tap source = this.getPlatform().getTabDelimitedFile(sourceFields, "input/path", SinkMode.KEEP);
        Fields sinkFields = new Fields(new Comparable[]{"third", "fourth"});
        Tap sink = this.getPlatform().getTabDelimitedFile(sinkFields, "output/path", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"third"}));
        this.verify(source, sink, pipe);
    }

    @Test
    public void testGroupBySortResolver() throws Exception {
        Fields sourceFields = new Fields(new Comparable[]{"first", "second"});
        Tap source = this.getPlatform().getTabDelimitedFile(sourceFields, "input/path", SinkMode.KEEP);
        Fields sinkFields = new Fields(new Comparable[]{"third", "fourth"});
        Tap sink = this.getPlatform().getTabDelimitedFile(sinkFields, "output/path", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"first"}), new Fields(new Comparable[]{"third"}));
        this.verify(source, sink, pipe);
    }

    @Test
    public void testEveryArgResolver() throws Exception {
        Fields sourceFields = new Fields(new Comparable[]{"first", "second"});
        Tap source = this.getPlatform().getTabDelimitedFile(sourceFields, "input/path", SinkMode.KEEP);
        Fields sinkFields = new Fields(new Comparable[]{"third", "fourth"});
        Tap sink = this.getPlatform().getTabDelimitedFile(sinkFields, "output/path", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"first"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"third"}), (Aggregator)new Count());
        this.verify(source, sink, pipe);
    }

    @Test
    public void testEveryOutResolver() throws Exception {
        Fields sourceFields = new Fields(new Comparable[]{"first", "second"});
        Tap source = this.getPlatform().getTabDelimitedFile(sourceFields, "input/path", SinkMode.KEEP);
        Fields sinkFields = new Fields(new Comparable[]{"third", "fourth"});
        Tap sink = this.getPlatform().getTabDelimitedFile(sinkFields, "output/path", SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"first"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"second"}), (Aggregator)new Count(), new Fields(new Comparable[]{"third"}));
        this.verify(source, sink, pipe);
    }
}

