/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowSkipIfSinkExists;
import cascading.flow.FlowSkipStrategy;
import cascading.flow.FlowStep;
import cascading.flow.FlowStepStrategy;
import cascading.operation.Aggregator;
import cascading.operation.Function;
import cascading.operation.aggregator.Count;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryIterator;
import data.InputData;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;

public class FlowStrategiesPlatformTest
extends PlatformTestCase {
    public FlowStrategiesPlatformTest() {
        super(false);
    }

    @Test
    public void testSkipStrategiesReplace() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("replace"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        sink.deleteResource(flow.getConfig());
        FlowStrategiesPlatformTest.assertTrue((String)"default skip", (!flow.getFlowSkipStrategy().skipFlow(flow) ? 1 : 0) != 0);
        FlowStrategiesPlatformTest.assertTrue((String)"exist skip", (!new FlowSkipIfSinkExists().skipFlow(flow) ? 1 : 0) != 0);
        flow.complete();
        FlowStrategiesPlatformTest.assertTrue((String)"default skip", (!flow.getFlowSkipStrategy().skipFlow(flow) ? 1 : 0) != 0);
        FlowStrategiesPlatformTest.assertTrue((String)"exist skip", (!new FlowSkipIfSinkExists().skipFlow(flow) ? 1 : 0) != 0);
        FlowSkipStrategy old = flow.getFlowSkipStrategy();
        FlowSkipStrategy replaced = flow.setFlowSkipStrategy((FlowSkipStrategy)new FlowSkipIfSinkExists());
        FlowStrategiesPlatformTest.assertTrue((String)"not same instance", (old == replaced ? 1 : 0) != 0);
        FlowStrategiesPlatformTest.validateLength((TupleEntryIterator)flow.openSource(), (int)10);
        FlowStrategiesPlatformTest.validateLength((Flow)flow, (int)10, null);
    }

    @Test
    public void testSkipStrategiesKeep() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("keep"), SinkMode.KEEP);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        sink.deleteResource(flow.getConfig());
        FlowStrategiesPlatformTest.assertTrue((String)"default skip", (!flow.getFlowSkipStrategy().skipFlow(flow) ? 1 : 0) != 0);
        FlowStrategiesPlatformTest.assertTrue((String)"exist skip", (!new FlowSkipIfSinkExists().skipFlow(flow) ? 1 : 0) != 0);
        flow.complete();
        FlowStrategiesPlatformTest.assertTrue((String)"default skip", (boolean)flow.getFlowSkipStrategy().skipFlow(flow));
        FlowStrategiesPlatformTest.assertTrue((String)"exist skip", (boolean)new FlowSkipIfSinkExists().skipFlow(flow));
        FlowStrategiesPlatformTest.validateLength((TupleEntryIterator)flow.openSource(), (int)10);
        FlowStrategiesPlatformTest.validateLength((Flow)flow, (int)10, null);
    }

    @Test
    public void testFlowStepStrategy() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("simple"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        final boolean[] wasApplied = new boolean[]{false};
        flow.setFlowStepStrategy(new FlowStepStrategy(){

            public void apply(Flow flow, List predecessorSteps, FlowStep flowStep) {
                wasApplied[0] = true;
                TestCase.assertTrue((boolean)predecessorSteps.isEmpty());
            }
        });
        flow.complete();
        FlowStrategiesPlatformTest.assertTrue((boolean)wasApplied[0]);
        FlowStrategiesPlatformTest.validateLength((Flow)flow, (int)8, null);
    }
}

