/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.Flow;
import cascading.flow.FlowListener;
import cascading.stats.CascadingStats;

public class CountingFlowListener
implements FlowListener {
    public int started = 0;
    public int stopping = 0;
    public int completed = 0;
    public int successful = 0;
    public int failed = 0;
    public int stopped = 0;
    public int skipped = 0;
    public int thrown = 0;

    public void onStarting(Flow flow) {
        ++this.started;
    }

    public void onStopping(Flow flow) {
        ++this.stopping;
    }

    public void onCompleted(Flow flow) {
        ++this.completed;
        CascadingStats.Status status = flow.getFlowStats().getStatus();
        switch (status) {
            case PENDING: {
                break;
            }
            case SKIPPED: {
                ++this.skipped;
                break;
            }
            case STARTED: {
                break;
            }
            case SUBMITTED: {
                break;
            }
            case RUNNING: {
                break;
            }
            case SUCCESSFUL: {
                ++this.successful;
                break;
            }
            case STOPPED: {
                ++this.stopped;
                break;
            }
            case FAILED: {
                ++this.failed;
            }
        }
    }

    public boolean onThrowable(Flow flow, Throwable throwable) {
        ++this.thrown;
        return false;
    }
}

