/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.operation.Buffer;
import cascading.operation.BufferCall;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import data.InputData;
import java.util.Iterator;
import org.junit.Test;

public class UnmodifiablePipesPlatformTest
extends PlatformTestCase {
    public UnmodifiablePipesPlatformTest() {
        super(false);
    }

    @Test
    public void testUnmodifiable() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLhs);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"lhs", "rhs"}), " ", InputData.inputFileLhs);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("simple"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"lhs"}), (Function)new TestFunction(), Fields.REPLACE);
        pipe = new Each(pipe, new Fields(new Comparable[]{"lhs"}), (Filter)new TestFilter());
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"lhs"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"rhs"}), (Aggregator)new TestAggregator(), Fields.ALL);
        pipe = new Each(pipe, new Fields(new Comparable[]{"lhs"}), (Function)new TestFunction(), Fields.REPLACE);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"lhs"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"lhs"}), (Buffer)new TestBuffer(), Fields.RESULTS);
        pipe = new Each(pipe, new Fields(new Comparable[]{"lhs"}), (Function)new TestFunction(), Fields.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        UnmodifiablePipesPlatformTest.validateLength((Flow)flow, (int)5, null);
    }

    public static class TestBuffer
    extends BaseOperation
    implements Buffer {
        public TestBuffer() {
            super(Fields.ARGS);
        }

        public void operate(FlowProcess flowProcess, BufferCall bufferCall) {
            if (!bufferCall.getGroup().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!bufferCall.getGroup().getTuple().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (bufferCall.getJoinerClosure() != null) {
                throw new IllegalStateException("joiner closure should be null");
            }
            Iterator iterator = bufferCall.getArgumentsIterator();
            while (iterator.hasNext()) {
                TupleEntry tupleEntry = (TupleEntry)iterator.next();
                if (!tupleEntry.isUnmodifiable()) {
                    throw new IllegalStateException("is modifiable");
                }
                if (!tupleEntry.getTuple().isUnmodifiable()) {
                    throw new IllegalStateException("is modifiable");
                }
                Tuple result = new Tuple(tupleEntry.getTuple());
                bufferCall.getOutputCollector().add(result);
                if (!result.isUnmodifiable()) continue;
                throw new IllegalStateException("is unmodifiable");
            }
        }
    }

    public static class TestAggregator
    extends BaseOperation
    implements Aggregator {
        public TestAggregator() {
            super(Fields.ARGS);
        }

        public void start(FlowProcess flowProcess, AggregatorCall aggregatorCall) {
            if (!aggregatorCall.getGroup().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!aggregatorCall.getGroup().getTuple().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
        }

        public void aggregate(FlowProcess flowProcess, AggregatorCall aggregatorCall) {
            if (!aggregatorCall.getGroup().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!aggregatorCall.getGroup().getTuple().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!aggregatorCall.getArguments().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!aggregatorCall.getArguments().getTuple().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
        }

        public void complete(FlowProcess flowProcess, AggregatorCall aggregatorCall) {
            if (!aggregatorCall.getGroup().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!aggregatorCall.getGroup().getTuple().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            Tuple result = new Tuple(new Object[]{"some value"});
            aggregatorCall.getOutputCollector().add(result);
            if (result.isUnmodifiable()) {
                throw new IllegalStateException("is unmodifiable");
            }
        }
    }

    public static class TestFilter
    extends BaseOperation
    implements Filter {
        public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
            if (!filterCall.getArguments().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!filterCall.getArguments().getTuple().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            return false;
        }
    }

    public static class TestFunction
    extends BaseOperation
    implements Function {
        public TestFunction() {
            super(Fields.ARGS);
        }

        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            if (!functionCall.getArguments().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            if (!functionCall.getArguments().getTuple().isUnmodifiable()) {
                throw new IllegalStateException("is modifiable");
            }
            Tuple result = new Tuple(functionCall.getArguments().getTuple());
            functionCall.getOutputCollector().add(result);
            if (result.isUnmodifiable()) {
                throw new IllegalStateException("is unmodifiable");
            }
        }
    }
}

