/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.operation.Insert;
import cascading.operation.regex.RegexParser;
import cascading.operation.regex.RegexSplitter;
import cascading.operation.text.DateParser;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.util.NullSafeReverseComparator;
import cascading.util.Util;
import data.InputData;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class SortedValuesPlatformTest
extends PlatformTestCase {
    private String apacheCommonRegex = "^([^ ]*) +[^ ]* +[^ ]* +\\[([^]]*)\\] +\\\"([^ ]*) ([^ ]*) [^ ]*\\\" ([^ ]*) ([^ ]*).*$";
    private RegexParser apacheCommonParser = new RegexParser(new Fields(new Comparable[]{"ip", "time", "method", "event", "status", "size"}), this.apacheCommonRegex, new int[]{1, 2, 3, 4, 5, 6});

    public SortedValuesPlatformTest() {
        super(false);
    }

    @Test
    public void testCoGroupComparatorValues() throws Exception {
        this.runCoGroupComparatorTest("cogroupcompareforward", false);
    }

    @Test
    public void testCoGroupComparatorValuesReversed() throws Exception {
        this.runCoGroupComparatorTest("cogroupcomparereversed", true);
    }

    private void runCoGroupComparatorTest(String path, boolean reverseSort) throws IOException, ParseException {
        this.getPlatform().copyFromLocal(InputData.inputFileApache200);
        this.getPlatform().copyFromLocal(InputData.inputFileIps);
        Tap sourceApache = this.getPlatform().getTextFile(InputData.inputFileApache200);
        Tap sourceIP = this.getPlatform().getTextFile(InputData.inputFileIps);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath(path), SinkMode.REPLACE);
        Pipe apachePipe = new Pipe("apache");
        apachePipe = new Each(apachePipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
        apachePipe = new Each(apachePipe, (Function)new Insert(new Fields(new Comparable[]{"col"}), new Object[]{1}), Fields.ALL);
        apachePipe = new Each(apachePipe, new Fields(new Comparable[]{"ip"}), (Function)new RegexParser(new Fields(new Comparable[]{"octet"}), "^[^.]*"), new Fields(new Comparable[]{"col", "status", "event", "octet", "size"}));
        apachePipe = new Each(apachePipe, new Fields(new Comparable[]{"octet"}), (Function)new Identity(new Class[]{Long.TYPE}), Fields.REPLACE);
        Fields groupApache = new Fields(new Comparable[]{"octet"});
        groupApache.setComparator((Comparable)((Object)"octet"), this.getPlatform().getLongComparator(reverseSort));
        Pipe ipPipe = new Pipe("ip");
        ipPipe = new Each(ipPipe, new Fields(new Comparable[]{"line"}), (Function)new Identity(new Fields(new Comparable[]{"rawip"})));
        ipPipe = new Each(ipPipe, new Fields(new Comparable[]{"rawip"}), (Function)new RegexParser(new Fields(new Comparable[]{"rawoctet"}), "^[^.]*"), new Fields(new Comparable[]{"rawoctet"}));
        ipPipe = new Each(ipPipe, new Fields(new Comparable[]{"rawoctet"}), (Function)new Identity(new Class[]{Long.TYPE}), Fields.REPLACE);
        Fields groupIP = new Fields(new Comparable[]{"rawoctet"});
        groupIP.setComparator((Comparable)((Object)"rawoctet"), this.getPlatform().getLongComparator(reverseSort));
        CoGroup pipe = new CoGroup(apachePipe, groupApache, ipPipe, groupIP);
        pipe = new Each((Pipe)pipe, (Function)new Identity());
        Map<Object, Object> properties = this.getProperties();
        if (this.getPlatform().isMapReduce() && this.getPlatform().getNumMapTasks(properties) != null) {
            this.getPlatform().setNumMapTasks(properties, 13);
        }
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("apache", sourceApache);
        sources.put("ip", sourceIP);
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)pipe);
        flow.complete();
        this.validateFile(sink, 199, 16, reverseSort, 5);
    }

    @Test
    public void testComprehensiveGroupBy() throws IOException {
        int i;
        Boolean[][] testArray = new Boolean[][]{{false, null, false}, {true, null, false}, {false, null, true}, {true, null, true}, {false, false, false}, {true, false, false}, {true, true, false}, {false, true, false}, {false, false, true}, {true, false, true}, {true, true, true}, {false, true, true}};
        for (i = 0; i < testArray.length; ++i) {
            this.runComprehensiveCase(testArray[i], false);
        }
        for (i = 0; i < testArray.length; ++i) {
            this.runComprehensiveCase(testArray[i], true);
        }
    }

    private void runComprehensiveCase(Boolean[] testCase, boolean useCollectionsComparator) throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileCrossNulls);
        String test = Util.join((Object[])testCase, (String)"_", (boolean)true) + "_" + useCollectionsComparator;
        String path = "comprehensive/" + test;
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileCrossNulls);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"num", "lower", "upper"}).applyTypes(new Type[]{Long.class, String.class, String.class}), " ", this.getOutputPath(path), SinkMode.REPLACE);
        sink.getScheme().setNumSinkParts(1);
        Pipe pipe = new Pipe("comprehensivesort");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower", "upper"}), "\\s"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"num"}), (Function)new Identity(new Class[]{Long.class}), Fields.REPLACE);
        Fields groupFields = new Fields(new Comparable[]{"num"});
        if (testCase[0].booleanValue()) {
            groupFields.setComparator((Comparable)((Object)"num"), (Comparator)(useCollectionsComparator ? new NullSafeReverseComparator() : this.getPlatform().getLongComparator(true)));
        }
        Fields sortFields = null;
        if (testCase[1] != null) {
            sortFields = new Fields(new Comparable[]{"upper"});
            if (testCase[1].booleanValue()) {
                sortFields.setComparator((Comparable)((Object)"upper"), (Comparator)(useCollectionsComparator ? new NullSafeReverseComparator() : this.getPlatform().getStringComparator(true)));
            }
        }
        pipe = new GroupBy(pipe, groupFields, sortFields, testCase[2].booleanValue());
        Map<Object, Object> properties = this.getProperties();
        if (this.getPlatform().isMapReduce() && this.getPlatform().getNumMapTasks(properties) != null) {
            this.getPlatform().setNumMapTasks(properties, 13);
        }
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        this.validateCase(test, testCase, sink);
    }

    private void validateCase(String test, Boolean[] testCase, Tap sink) throws IOException {
        TupleEntryIterator iterator = sink.openForRead(this.getPlatform().getFlowProcess());
        LinkedHashMap group = new LinkedHashMap();
        while (iterator.hasNext()) {
            Tuple tuple = ((TupleEntry)iterator.next()).getTuple();
            if (!group.containsKey(tuple.getLong(0))) {
                group.put(tuple.getLong(0), new ArrayList());
            }
            ((List)group.get(tuple.getLong(0))).add(tuple.getString(2));
        }
        boolean groupIsReversed = testCase[0];
        if (testCase[2].booleanValue()) {
            groupIsReversed = !groupIsReversed;
        }
        this.compare("grouping+" + test, groupIsReversed, group.keySet());
        if (testCase[1] == null) {
            return;
        }
        boolean valueIsReversed = testCase[1];
        if (testCase[2].booleanValue()) {
            valueIsReversed = !valueIsReversed;
        }
        for (Long grouping : group.keySet()) {
            this.compare("values+" + test, valueIsReversed, (Collection)group.get(grouping));
        }
    }

    private void compare(String test, boolean isReversed, Collection values) {
        ArrayList groups = new ArrayList(values);
        ArrayList sortedGroups = new ArrayList(groups);
        Collections.sort(sortedGroups, isReversed ? Collections.reverseOrder() : null);
        SortedValuesPlatformTest.assertEquals((String)test, sortedGroups, groups);
    }

    @Test
    public void testSortFails() throws Exception {
        Tap source = this.getPlatform().getTextFile("foosource");
        Tap sink = this.getPlatform().getTextFile("foosink");
        Pipe pipe = new Pipe("apache");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
        pipe = new Each(pipe, (Function)new Insert(new Fields(new Comparable[]{"col"}), new Object[]{1}), Fields.ALL);
        pipe = new Each(pipe, new Fields(new Comparable[]{"time"}), (Function)new DateParser("dd/MMM/yyyy:HH:mm:ss Z"), new Fields(new Comparable[]{"col", "status", "ts", "event", "ip", "size"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"col"}), new Fields(new Comparable[]{"does-not-exist"}));
        pipe = new Each(pipe, (Function)new Identity());
        try {
            this.getPlatform().getFlowConnector().connect(source, sink, pipe);
            SortedValuesPlatformTest.fail((String)"did not throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateFile(Tap tap, int length, int uniqueValues, boolean isReversed, int comparePosition) throws IOException, ParseException {
        TupleEntryIterator iterator = tap.openForRead(this.getPlatform().getFlowProcess());
        HashSet<Long> values = new HashSet<Long>();
        long lastValue = isReversed ? Long.MAX_VALUE : Long.MIN_VALUE;
        int count = 0;
        while (iterator.hasNext()) {
            Tuple tuple = ((TupleEntry)iterator.next()).getTuple();
            ++count;
            tuple = new Tuple((Object[])tuple.getString(1).split("\t"));
            long value = tuple.getLong(comparePosition);
            values.add(value);
            if (isReversed) {
                SortedValuesPlatformTest.assertTrue((String)("out of order in " + tap), (lastValue >= value ? 1 : 0) != 0);
            } else {
                SortedValuesPlatformTest.assertTrue((String)("out of order in " + tap), (lastValue <= value ? 1 : 0) != 0);
            }
            lastValue = value;
        }
        if (length != -1) {
            SortedValuesPlatformTest.assertEquals((String)("length of " + tap), (int)length, (int)count);
        }
        if (uniqueValues != -1) {
            SortedValuesPlatformTest.assertEquals((String)("unique values of " + tap), (int)uniqueValues, (int)values.size());
        }
    }
}

