/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.operation.Debug;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexSplitter;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import data.InputData;
import java.io.File;
import java.io.IOException;
import org.junit.Test;

public class RegressionMiscPlatformTest
extends PlatformTestCase {
    @Test
    public void testWriteDot() throws Exception {
        Tap source = this.getPlatform().getTextFile("input");
        Tap sink = this.getPlatform().getTextFile("unknown");
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(Fields.UNKNOWN));
        pipe = new Each(pipe, (Filter)new Debug());
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(2)}), (Function)new Identity(new Fields(new Comparable[]{"label"})));
        pipe = new Each(pipe, (Filter)new Debug());
        pipe = new Each(pipe, new Fields(new Comparable[]{"label"}), (Filter)new RegexFilter("[A-Z]*"));
        pipe = new Each(pipe, (Filter)new Debug());
        pipe = new GroupBy(pipe, Fields.ALL);
        pipe = new GroupBy(pipe, Fields.ALL);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        String outputPath = this.getOutputPath("writedot.dot");
        flow.writeDOT(outputPath);
        RegressionMiscPlatformTest.assertTrue((boolean)new File(outputPath).exists());
        outputPath = this.getOutputPath("writestepdot.dot");
        flow.writeStepsDOT(outputPath);
        RegressionMiscPlatformTest.assertTrue((boolean)new File(outputPath).exists());
    }

    @Test
    public void testSinkDeclaredFieldsFails() throws IOException {
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), "input");
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new RegexSplitter(new Fields(new Comparable[]{"first", "second", "third"}), "\\s"), Fields.ALL);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), new Fields(new Comparable[]{"first", "second", "fifth"}), this.getOutputPath("output"), SinkMode.REPLACE);
        try {
            this.getPlatform().getFlowConnector().connect(source, sink, pipe);
            RegressionMiscPlatformTest.fail((String)"did not fail on bad sink field names");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTupleEntryNextTwice() throws IOException {
        Tap tap = this.getPlatform().getTextFile(InputData.inputFileNums10);
        TupleEntryIterator iterator = tap.openForRead(this.getPlatform().getFlowProcess());
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        RegressionMiscPlatformTest.assertFalse((boolean)iterator.hasNext());
        RegressionMiscPlatformTest.assertEquals((int)10, (int)count);
    }

    @Test
    public void testTapReplaceOnWrite() throws IOException {
        int i;
        String tapPath = this.getOutputPath("tapreplace");
        Tap tap = this.getPlatform().getTextFile(tapPath, SinkMode.KEEP);
        TupleEntryCollector collector = tap.openForWrite(this.getPlatform().getFlowProcess());
        for (i = 0; i < 100; ++i) {
            collector.add(new Tuple(new Object[]{"string", "" + i, i}));
        }
        collector.close();
        tap = this.getPlatform().getTextFile(tapPath, SinkMode.REPLACE);
        collector = tap.openForWrite(this.getPlatform().getFlowProcess());
        for (i = 0; i < 100; ++i) {
            collector.add(new Tuple(new Object[]{"string", "" + i, i}));
        }
        collector.close();
    }
}

