/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.CascadingTestCase;
import cascading.flow.FlowConnectorProps;
import cascading.operation.DebugLevel;
import cascading.platform.PlatformRunner;
import cascading.platform.TestPlatform;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PlatformRunner.class)
public abstract class PlatformTestCase
extends CascadingTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformTestCase.class);
    static Set<String> allPaths = new HashSet<String>();
    Set<String> currentPaths = new HashSet<String>();
    private transient TestPlatform platform = null;
    private transient boolean useCluster;
    private transient int numMapTasks;
    private transient int numGatherPartitions;

    protected PlatformTestCase(boolean useCluster) {
        this.useCluster = useCluster;
    }

    protected PlatformTestCase(boolean useCluster, int numMapTasks, int numGatherPartitions) {
        this(useCluster);
        this.numMapTasks = numMapTasks;
        this.numGatherPartitions = numGatherPartitions;
    }

    protected PlatformTestCase() {
        this(false);
    }

    public void installPlatform(TestPlatform platform) {
        this.platform = platform;
        this.platform.setUseCluster(this.useCluster);
        if (this.platform.isMapReduce()) {
            platform.setNumMappers(this.numMapTasks);
            platform.setNumReducers(this.numGatherPartitions);
        }
        if (this.platform.isDAG()) {
            platform.setNumGatherPartitions(this.numGatherPartitions);
        }
    }

    public TestPlatform getPlatform() {
        return this.platform;
    }

    protected String[] getOutputPathElements() {
        return new String[]{PlatformTestCase.getTestOutputRoot(), this.getPlatformName(), this.getTestCaseName(), this.getTestName()};
    }

    protected String[] getPlanPathElements() {
        return new String[]{PlatformTestCase.getTestPlanRoot(), this.getPlatformName(), this.getTestCaseName(), this.getTestName()};
    }

    public String getOutputPath(String path) {
        String result = this.makeOutputPath(path);
        if (allPaths.contains(result)) {
            throw new IllegalStateException("path already has been used:" + result);
        }
        allPaths.add(result);
        this.currentPaths.add(result);
        return result;
    }

    protected String makeOutputPath(String path) {
        if (path.startsWith("/")) {
            return this.getOutputPath() + path;
        }
        return this.getOutputPath() + "/" + path;
    }

    public String getPlatformName() {
        return this.platform.getName();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getPlatform().setUp();
    }

    public Map<Object, Object> getProperties() {
        return new HashMap<Object, Object>(this.getPlatform().getProperties());
    }

    protected void copyFromLocal(String inputFile) throws IOException {
        this.getPlatform().copyFromLocal(inputFile);
    }

    protected Map<Object, Object> disableDebug() {
        Map<Object, Object> properties = this.getProperties();
        FlowConnectorProps.setDebugLevel(properties, (DebugLevel)DebugLevel.NONE);
        return properties;
    }

    @After
    public void tearDown() throws Exception {
        try {
            for (String path : this.currentPaths) {
                LOG.info("copying to local {}", (Object)path);
                if (!this.getPlatform().isUseCluster() || !this.getPlatform().remoteExists(path)) continue;
                this.getPlatform().copyToLocal(path);
            }
            this.currentPaths.clear();
        }
        finally {
            this.getPlatform().tearDown();
        }
    }
}

