/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.CascadingTestCase;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.Test;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=SuiteMethod.class)
public class ComparePlatformsTest
extends CascadingTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ComparePlatformsTest.class);
    public static final String NONDETERMINISTIC = "-nondeterministic";

    public static junit.framework.Test suite() throws Exception {
        String root = System.getProperty("test.output.roots");
        if (root == null) {
            return new TestSuite();
        }
        LOG.info("output roots: {}", (Object)root);
        String[] roots = root.split(",");
        File localRoot = new File(ComparePlatformsTest.find(roots, "/cascading-local/"), "local");
        File hadoop3Root = new File(ComparePlatformsTest.find(roots, "/cascading-hadoop3-mr1/"), "hadoop3-mr1");
        File hadoop3TezRoot = new File(ComparePlatformsTest.find(roots, "/cascading-hadoop3-tez/"), "hadoop3-tez");
        LOG.info("local path: {}", (Object)localRoot);
        LOG.info("hadoop3-mr1 path: {}", (Object)hadoop3Root);
        LOG.info("hadoop3-tez path: {}", (Object)hadoop3TezRoot);
        TestSuite suite = new TestSuite();
        ComparePlatformsTest.createComparisons("local~hadoop3-mr1", localRoot, hadoop3Root, suite);
        ComparePlatformsTest.createComparisons("local~hadoop3-tez", localRoot, hadoop3TezRoot, suite);
        return suite;
    }

    private static void createComparisons(String comparison, File lhsRoot, File rhsRoot, TestSuite suite) {
        LOG.info("comparing directory: {}, with: {}", (Object)lhsRoot, (Object)rhsRoot);
        LinkedList lhsFiles = new LinkedList(FileUtils.listFiles((File)lhsRoot, (IOFileFilter)new RegexFileFilter("^[\\w-]+"), (IOFileFilter)TrueFileFilter.INSTANCE));
        LinkedList<File> rhsFiles = new LinkedList<File>();
        LOG.info("found lhs files: {}", (Object)lhsFiles.size());
        int rootLength = lhsRoot.toString().length() + 1;
        ListIterator iterator = lhsFiles.listIterator();
        while (iterator.hasNext()) {
            File localFile = (File)iterator.next();
            File file = new File(rhsRoot, localFile.toString().substring(rootLength));
            if (localFile.toString().endsWith(NONDETERMINISTIC)) {
                iterator.remove();
                continue;
            }
            if (file.exists()) {
                rhsFiles.add(file);
                continue;
            }
            iterator.remove();
        }
        LOG.info("running {} comparisons", (Object)lhsFiles.size());
        for (int i = 0; i < lhsFiles.size(); ++i) {
            File localFile = (File)lhsFiles.get(i);
            File hadoopFile = (File)rhsFiles.get(i);
            suite.addTest((junit.framework.Test)new CompareTestCase(comparison, localFile, hadoopFile));
        }
    }

    private static String find(String[] roots, String string) {
        for (String root : roots) {
            if (!root.contains(string)) continue;
            return root;
        }
        throw new IllegalStateException("not found in roots: " + string);
    }

    public static class CompareTestCase
    extends TestCase {
        File localFile;
        File hadoopFile;

        public CompareTestCase(String comparison, File localFile, File hadoopFile) {
            super("testFiles");
            this.localFile = localFile;
            this.hadoopFile = hadoopFile;
        }

        @Test
        public void testFiles() throws IOException {
            LinkedList<String> localLines = this.getLines(this.localFile);
            LinkedList<String> hadoopLines = this.getLines(this.hadoopFile);
            CompareTestCase.assertEquals((String)(this.localFile + " != " + this.hadoopFile), (int)localLines.size(), (int)hadoopLines.size());
            if (localLines.size() == 0) {
                return;
            }
            Collections.sort(localLines);
            Collections.sort(hadoopLines);
            if (this.hasLineNumbers(localLines)) {
                this.trimLineNumbers(localLines);
                this.trimLineNumbers(hadoopLines);
            }
            for (int i = 0; i < localLines.size(); ++i) {
                String localLine = localLines.get(i);
                CompareTestCase.assertTrue((String)(this.localFile + " - not in hadoop lines: " + localLine), (boolean)hadoopLines.contains(localLine));
            }
        }

        private void trimLineNumbers(LinkedList<String> lines) {
            ListIterator<String> iterator = lines.listIterator();
            while (iterator.hasNext()) {
                iterator.set(((String)iterator.next()).replaceFirst("^\\d+\\s(.*)$", "$1"));
            }
        }

        private boolean hasLineNumbers(List<String> lines) {
            LinkedList<Integer> values = new LinkedList<Integer>();
            for (String line : lines) {
                if (!line.matches("^\\d+\\s.*$")) {
                    return false;
                }
                String string = line.replaceFirst("^(\\d+)\\s.*$", "$1");
                if (string == null || string.isEmpty()) {
                    return false;
                }
                values.add(Integer.parseInt(string));
            }
            Collections.sort(values);
            int last = -1;
            for (Integer n : values) {
                if (last >= n) {
                    return false;
                }
                last = n;
            }
            return true;
        }

        private LinkedList<String> getLines(File localFile) throws IOException {
            LinkedList<String> lines = new LinkedList<String>();
            if (!localFile.isDirectory()) {
                return this.populate(localFile, lines);
            }
            Collection subFiles = FileUtils.listFiles((File)localFile, (IOFileFilter)new RegexFileFilter("^part-.*"), null);
            for (File subFile : subFiles) {
                this.populate(subFile, lines);
            }
            return lines;
        }

        private LinkedList<String> populate(File localFile, LinkedList<String> lines) throws IOException {
            LineIterator iterator = FileUtils.lineIterator((File)localFile, (String)"UTF-8");
            while (iterator.hasNext()) {
                lines.add(iterator.next());
            }
            return lines;
        }
    }
}

