/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.InnerJoinTestBuffer;
import cascading.PlatformTestCase;
import cascading.TestBuffer;
import cascading.flow.Flow;
import cascading.operation.Aggregator;
import cascading.operation.Buffer;
import cascading.operation.Function;
import cascading.operation.Insert;
import cascading.operation.aggregator.Count;
import cascading.operation.buffer.FirstNBuffer;
import cascading.operation.regex.RegexSplitter;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.joiner.BufferJoin;
import cascading.pipe.joiner.Joiner;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import data.InputData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Test;

public class BufferPipesPlatformTest
extends PlatformTestCase {
    public BufferPipesPlatformTest() {
        super(false);
    }

    @Test
    public void testSimpleBuffer() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLhs);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileLhs);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("simple"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower"}), "\\s"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"num"}));
        pipe = new Every(pipe, (Buffer)new TestBuffer(new Fields(new Comparable[]{"next"}), 2, true, true, "next"));
        pipe = new Each(pipe, (Function)new Insert(new Fields(new Comparable[]{"final"}), new Object[]{"final"}), Fields.ALL);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BufferPipesPlatformTest.validateLength((Flow)flow, (int)23, null);
        List results = BufferPipesPlatformTest.getSinkAsList((Flow)flow);
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tnull\tnext\tfinal"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\ta\tnext\tfinal"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tb\tnext\tfinal"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tc\tnext\tfinal"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tnull\tnext\tfinal"})));
    }

    @Test
    public void testSimpleBuffer2() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLhs);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileLhs);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("simple2"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower"}), "\\s"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"num"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"lower"}), (Buffer)new TestBuffer(new Fields(new Comparable[]{"next"}), 1, true, "next"), Fields.RESULTS);
        pipe = new Each(pipe, (Function)new Insert(new Fields(new Comparable[]{"final"}), new Object[]{"final"}), Fields.ALL);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BufferPipesPlatformTest.validateLength((Flow)flow, (int)18, null);
        List results = BufferPipesPlatformTest.getSinkAsList((Flow)flow);
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"next\tfinal"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"next\tfinal"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"next\tfinal"})));
    }

    @Test
    public void testSimpleBuffer3() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileJoined);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileJoined);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("simple3"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower", "upper"}), "\\s"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"num"}));
        pipe = new Every(pipe, (Buffer)new TestBuffer(new Fields(new Comparable[]{"new"}), (Comparable)new Tuple(new Object[]{"new"})), new Fields(new Comparable[]{"new", "lower", "upper"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BufferPipesPlatformTest.validateLength((Flow)flow, (int)5, null);
        List results = BufferPipesPlatformTest.getSinkAsList((Flow)flow);
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"new\ta\tA"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"new\tb\tB"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"new\tc\tC"})));
    }

    @Test
    public void testIdentityBuffer() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLhs);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileLhs);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("identity"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower"}), "\\s"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"num"}));
        pipe = new Every(pipe, Fields.VALUES, (Buffer)new TestBuffer(Fields.ARGS), Fields.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BufferPipesPlatformTest.validateLength((Flow)flow, (int)13);
        List results = BufferPipesPlatformTest.getSinkAsList((Flow)flow);
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\ta"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tb"})));
        BufferPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\tc"})));
    }

    @Test
    public void testJoinerClosure() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileUpper);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("cogroup"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        CoGroup splice = new CoGroup((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), (Joiner)new BufferJoin());
        splice = new Every((Pipe)splice, (Buffer)new InnerJoinTestBuffer(Fields.size((int)4)), Fields.RESULTS);
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        flow.complete();
        BufferPipesPlatformTest.validateLength((Flow)flow, (int)5);
        List values = BufferPipesPlatformTest.getSinkAsList((Flow)flow);
        BufferPipesPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        BufferPipesPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
    }

    @Test
    public void testJoinerClosureFail() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileUpper);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), "failpath", SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        CoGroup splice = new CoGroup((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), (Joiner)new BufferJoin());
        splice = new Every((Pipe)splice, Fields.size((int)1), (Aggregator)new Count(), Fields.RESULTS);
        try {
            Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
            BufferPipesPlatformTest.fail();
        }
        catch (Exception exception) {
            BufferPipesPlatformTest.assertTrue((boolean)exception.getMessage().contains("Fields.NONE"));
        }
    }

    @Test
    public void testFirstNBuffer() throws Exception {
        HashSet<Tuple> expected = new HashSet<Tuple>();
        expected.add(new Tuple(new Object[]{"1", "a"}));
        expected.add(new Tuple(new Object[]{"2", "b"}));
        expected.add(new Tuple(new Object[]{"3", "c"}));
        expected.add(new Tuple(new Object[]{"4", "b"}));
        expected.add(new Tuple(new Object[]{"5", "a"}));
        this.runFirstNBuffer(expected, false, false);
    }

    @Test
    public void testFirstNBufferForward() throws Exception {
        HashSet<Tuple> expected = new HashSet<Tuple>();
        expected.add(new Tuple(new Object[]{"1", "a"}));
        expected.add(new Tuple(new Object[]{"2", "b"}));
        expected.add(new Tuple(new Object[]{"3", "c"}));
        expected.add(new Tuple(new Object[]{"4", "b"}));
        expected.add(new Tuple(new Object[]{"5", "a"}));
        this.runFirstNBuffer(expected, true, false);
    }

    @Test
    public void testFirstNBufferReverse() throws Exception {
        HashSet<Tuple> expected = new HashSet<Tuple>();
        expected.add(new Tuple(new Object[]{"1", "c"}));
        expected.add(new Tuple(new Object[]{"2", "d"}));
        expected.add(new Tuple(new Object[]{"3", "c"}));
        expected.add(new Tuple(new Object[]{"4", "d"}));
        expected.add(new Tuple(new Object[]{"5", "e"}));
        this.runFirstNBuffer(expected, true, true);
    }

    protected void runFirstNBuffer(Set<Tuple> expected, boolean secondarySort, boolean reverseOrder) throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLhs);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"num", "lower"}), " ", InputData.inputFileLhs);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"num", "lower"}), "\t", this.getOutputPath("firstn"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = !secondarySort ? new GroupBy(pipe, new Fields(new Comparable[]{"num"})) : new GroupBy(pipe, new Fields(new Comparable[]{"num"}), new Fields(new Comparable[]{"lower"}), reverseOrder);
        pipe = new Every(pipe, Fields.VALUES, (Buffer)new FirstNBuffer(Fields.ARGS, 1), Fields.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BufferPipesPlatformTest.validateLength((Flow)flow, (int)5);
        List results = BufferPipesPlatformTest.getSinkAsList((Flow)flow);
        expected.removeAll(results);
        BufferPipesPlatformTest.assertTrue((boolean)expected.isEmpty());
    }
}

