/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform;

import cascading.flow.FlowConnector;
import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.util.FieldTypeResolver;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(TestPlatform.class);
    public static final String CLUSTER_TESTING_PROPERTY = "test.cluster.enabled";
    public static final String PLATFORM_PREFIX = "platform.";
    private boolean useCluster = false;
    private boolean enableCluster = Boolean.parseBoolean(System.getProperty("test.cluster.enabled", Boolean.toString(this.enableCluster)));
    protected int numMappers = 0;
    protected int numReducers = 0;
    protected int numGatherPartitions = 0;

    public static Map<Object, Object> getGlobalProperties() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith(PLATFORM_PREFIX)) continue;
            properties.put(propertyName.substring(PLATFORM_PREFIX.length()), System.getProperty(propertyName));
        }
        if (!properties.isEmpty()) {
            LOG.info("platform property overrides: ", properties);
        }
        return properties;
    }

    protected TestPlatform() {
    }

    public String getName() {
        return this.getClass().getSimpleName().replaceAll("^(.*)Platform$", "$1").toLowerCase();
    }

    @Deprecated
    public boolean supportsGroupByAfterMerge() {
        return true;
    }

    public boolean isMapReduce() {
        return false;
    }

    public boolean isDAG() {
        return false;
    }

    public int getNumMappers() {
        return this.numMappers;
    }

    public void setNumMappers(int numMappers) {
        this.numMappers = numMappers;
    }

    public int getNumReducers() {
        return this.numReducers;
    }

    public void setNumReducers(int numReducers) {
        this.numReducers = numReducers;
    }

    public int getNumGatherPartitions() {
        return this.numGatherPartitions;
    }

    public void setNumGatherPartitions(int numGatherPartitions) {
        this.numGatherPartitions = numGatherPartitions;
    }

    public void setNumMapTasks(Map<Object, Object> properties, int numMapTasks) {
    }

    public void setNumReduceTasks(Map<Object, Object> properties, int numReduceTasks) {
    }

    public void setNumGatherPartitionTasks(Map<Object, Object> properties, int numReduceTasks) {
    }

    public Integer getNumMapTasks(Map<Object, Object> properties) {
        return null;
    }

    public Integer getNumReduceTasks(Map<Object, Object> properties) {
        return null;
    }

    public Integer getNumGatherPartitionTasks(Map<Object, Object> properties) {
        return null;
    }

    public abstract void setUp() throws IOException;

    public abstract Map<Object, Object> getProperties();

    public abstract void tearDown();

    public void setUseCluster(boolean useCluster) {
        this.useCluster = useCluster;
    }

    public boolean isUseCluster() {
        return this.enableCluster && this.useCluster;
    }

    public abstract void copyFromLocal(String var1) throws IOException;

    public abstract void copyToLocal(String var1) throws IOException;

    public abstract boolean remoteExists(String var1) throws IOException;

    public abstract boolean remoteRemove(String var1, boolean var2) throws IOException;

    public abstract <C> FlowProcess<C> getFlowProcess();

    public abstract FlowConnector getFlowConnector(Map<Object, Object> var1);

    public FlowConnector getFlowConnector() {
        return this.getFlowConnector(this.getProperties());
    }

    public abstract Tap getTap(Scheme var1, String var2, SinkMode var3);

    public Tap getTextFile(Fields sourceFields, String filename) {
        return this.getTextFile(sourceFields, filename, SinkMode.KEEP);
    }

    public Tap getTextFile(String filename) {
        return this.getTextFile(filename, SinkMode.KEEP);
    }

    public Tap getTextFile(String filename, SinkMode mode) {
        return this.getTextFile(null, filename, mode);
    }

    public Tap getTextFile(Fields sourceFields, String filename, SinkMode mode) {
        return this.getTextFile(sourceFields, Fields.ALL, filename, mode);
    }

    public abstract Tap getTextFile(Fields var1, Fields var2, String var3, SinkMode var4);

    public <C, I, O> Tap<? extends C, ? extends I, ? extends O> getDelimitedFile(Fields fields, String delimiter, String filename) {
        return this.getDelimitedFile(fields, false, delimiter, "\"", null, filename, SinkMode.KEEP);
    }

    public Tap getDelimitedFile(Fields fields, String delimiter, String filename, SinkMode mode) {
        return this.getDelimitedFile(fields, false, delimiter, "\"", null, filename, mode);
    }

    public Tap getTabDelimitedFile(Fields fields, String filename, SinkMode mode) {
        return this.getDelimitedFile(fields, false, "\t", "\"", null, filename, mode);
    }

    public Tap getTabDelimitedFile(Fields fields, boolean hasHeader, String filename, SinkMode mode) {
        return this.getDelimitedFile(fields, hasHeader, "\t", "\"", null, filename, mode);
    }

    public Tap getDelimitedFile(Fields fields, boolean hasHeader, String delimiter, String quote, String filename, SinkMode mode) {
        return this.getDelimitedFile(fields, hasHeader, delimiter, quote, null, filename, mode);
    }

    public Tap getDelimitedFile(Fields fields, String delimiter, String quote, String filename, SinkMode mode) {
        return this.getDelimitedFile(fields, false, delimiter, quote, null, filename, mode);
    }

    public Tap getDelimitedFile(Fields fields, String delimiter, Class[] types, String filename, SinkMode mode) {
        return this.getDelimitedFile(fields, false, delimiter, "\"", types, filename, mode);
    }

    public abstract Tap getDelimitedFile(Fields var1, boolean var2, String var3, String var4, Class[] var5, String var6, SinkMode var7);

    public abstract Tap getDelimitedFile(Fields var1, boolean var2, boolean var3, String var4, String var5, Class[] var6, String var7, SinkMode var8);

    public abstract Tap getDelimitedFile(String var1, String var2, FieldTypeResolver var3, String var4, SinkMode var5);

    public Tap getJSONFile(Fields fields, String filename) {
        return this.getJSONFile(fields, filename, SinkMode.KEEP);
    }

    public abstract Tap getJSONFile(Fields var1, String var2, SinkMode var3);

    public abstract Tap getPartitionTap(Tap var1, Partition var2, int var3);

    public abstract Scheme getTestConfigDefScheme();

    public abstract Scheme getTestFailScheme();

    public abstract Comparator getLongComparator(boolean var1);

    public abstract Comparator getStringComparator(boolean var1);

    public abstract String getHiddenTemporaryPath();

    protected String getApplicationJar() {
        String property = System.getProperty("mapred.jar", System.getProperty("cascading.app.appjar.path"));
        if (property == null || property.isEmpty()) {
            return null;
        }
        return property;
    }
}

