/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.debug;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowConnectorProps;
import cascading.flow.planner.BaseFlowStep;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.Debug;
import cascading.operation.DebugLevel;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.Operation;
import cascading.operation.assertion.AssertMatches;
import cascading.operation.assertion.AssertNotNull;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import java.util.Collection;
import java.util.Map;
import org.junit.Test;

public class BuildDebugPlatformTest
extends PlatformTestCase {
    @Test
    public void testDebugLevels() throws Exception {
        Tap source = this.getPlatform().getTextFile("input");
        Tap sink = this.getPlatform().getTextFile("output");
        Pipe pipe = new Pipe("test");
        String regex = "^([^ ]*) +[^ ]* +[^ ]* +\\[([^]]*)\\] +\\\"([^ ]*) ([^ ]*) [^ ]*\\\" ([^ ]*) ([^ ]*).*$";
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip", "time", "method", "event", "status", "size"}), regex, new int[]{1, 2, 3, 4, 5, 6}));
        pipe = new Each(pipe, AssertionLevel.STRICT, (Assertion)new AssertNotNull());
        pipe = new Each(pipe, DebugLevel.DEFAULT, new Debug());
        pipe = new Each(pipe, DebugLevel.VERBOSE, new Debug());
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), AssertionLevel.STRICT, (Assertion)new AssertMatches("^POST"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
        Map<Object, Object> properties = this.getProperties();
        BuildDebugPlatformTest.assertEquals((int)this.getDebugCount(this.getPlatform().getFlowConnector(properties).connect(source, sink, pipe)), (int)1);
        FlowConnectorProps.setDebugLevel(properties, (DebugLevel)DebugLevel.DEFAULT);
        BuildDebugPlatformTest.assertEquals((int)this.getDebugCount(this.getPlatform().getFlowConnector(properties).connect(source, sink, pipe)), (int)1);
        FlowConnectorProps.setDebugLevel(properties, (DebugLevel)DebugLevel.VERBOSE);
        BuildDebugPlatformTest.assertEquals((int)this.getDebugCount(this.getPlatform().getFlowConnector(properties).connect(source, sink, pipe)), (int)2);
        FlowConnectorProps.setDebugLevel(properties, (DebugLevel)DebugLevel.NONE);
        BuildDebugPlatformTest.assertEquals((int)this.getDebugCount(this.getPlatform().getFlowConnector(properties).connect(source, sink, pipe)), (int)0);
    }

    private int getDebugCount(Flow flow) {
        BaseFlowStep step = (BaseFlowStep)flow.getFlowSteps().get(0);
        Collection operations = step.getAllOperations();
        int count = 0;
        for (Operation operation : operations) {
            if (!(operation instanceof Debug)) continue;
            ++count;
        }
        return count;
    }
}

