/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowConnectorProps;
import cascading.operation.Aggregator;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.GroupAssertion;
import cascading.operation.aggregator.Count;
import cascading.operation.assertion.AssertEquals;
import cascading.operation.assertion.AssertGroupSizeEquals;
import cascading.operation.assertion.AssertMatches;
import cascading.operation.assertion.AssertNotNull;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import data.InputData;
import java.io.IOException;
import java.util.Map;
import org.junit.Test;

public class AppliedAssertionsPlatformTest
extends PlatformTestCase {
    private String apacheCommonRegex = "^([^ ]*) +[^ ]* +[^ ]* +\\[([^]]*)\\] +\\\"([^ ]*) ([^ ]*) [^ ]*\\\" ([^ ]*) ([^ ]*).*$";
    private RegexParser apacheCommonParser = new RegexParser(new Fields(new Comparable[]{"ip", "time", "method", "event", "status", "size"}), this.apacheCommonRegex, new int[]{1, 2, 3, 4, 5, 6});

    @Test
    public void testValueAssertionsPass() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("value/pass"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
        pipe = new Each(pipe, AssertionLevel.STRICT, (Assertion)new AssertNotNull());
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), AssertionLevel.STRICT, (Assertion)new AssertMatches("^POST"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"method", "count"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"count"}), AssertionLevel.STRICT, (Assertion)new AssertEquals(new Object[]{7L}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        AppliedAssertionsPlatformTest.validateLength((Flow)flow, (int)1, null);
    }

    @Test
    public void testValueAssertionsFail() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("value/fail"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
        pipe = new Each(pipe, AssertionLevel.STRICT, (Assertion)new AssertNotNull());
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), AssertionLevel.STRICT, (Assertion)new AssertMatches("^POST"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"method", "count"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"count"}), AssertionLevel.STRICT, (Assertion)new AssertEquals(new Object[]{0L}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        try {
            flow.complete();
            AppliedAssertionsPlatformTest.fail((String)"no assertions thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testValueAssertionsRemoval() throws Exception {
        this.runValueAssertions(AssertionLevel.NONE, AssertionLevel.STRICT, true);
        this.runValueAssertions(AssertionLevel.VALID, AssertionLevel.STRICT, true);
        this.runValueAssertions(AssertionLevel.STRICT, AssertionLevel.STRICT, false);
        this.runValueAssertions(AssertionLevel.NONE, AssertionLevel.VALID, true);
        this.runValueAssertions(AssertionLevel.VALID, AssertionLevel.VALID, false);
    }

    private void runValueAssertions(AssertionLevel planLevel, AssertionLevel setLevel, boolean pass) throws IOException {
        Flow flow;
        block4: {
            this.getPlatform().copyFromLocal(InputData.inputFileApache);
            Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
            Tap sink = this.getPlatform().getTextFile(this.getOutputPath("value/" + planLevel + "/" + setLevel), SinkMode.REPLACE);
            Pipe pipe = new Pipe("test");
            pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
            pipe = new Each(pipe, setLevel, (Assertion)new AssertNotNull());
            pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
            pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), setLevel, (Assertion)new AssertMatches("^POST"));
            pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
            pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"method", "count"}));
            pipe = new Each(pipe, new Fields(new Comparable[]{"count"}), setLevel, (Assertion)new AssertEquals(new Object[]{0L}));
            Map<Object, Object> properties = this.getPlatform().getProperties();
            FlowConnectorProps.setAssertionLevel(properties, (AssertionLevel)planLevel);
            flow = this.getPlatform().getFlowConnector(properties).connect(source, sink, pipe);
            try {
                flow.complete();
                if (!pass) {
                    AppliedAssertionsPlatformTest.fail((String)String.format("no assertions thrown %s %s %s", planLevel, setLevel, pass));
                }
            }
            catch (Exception exception) {
                if (!pass) break block4;
                AppliedAssertionsPlatformTest.fail((String)String.format("assertion thrown %s %s %s", planLevel, setLevel, pass));
            }
        }
        if (pass) {
            AppliedAssertionsPlatformTest.validateLength((Flow)flow, (int)1, null);
        }
    }

    @Test
    public void testGroupAssertionsPass() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("pass"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
        pipe = new Each(pipe, AssertionLevel.STRICT, (Assertion)new AssertNotNull());
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), AssertionLevel.STRICT, (Assertion)new AssertMatches("^POST"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"method", "count"}));
        pipe = new Every(pipe, AssertionLevel.STRICT, (GroupAssertion)new AssertGroupSizeEquals(7L));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        AppliedAssertionsPlatformTest.validateLength((Flow)flow, (int)1, null);
    }

    @Test
    public void testGroupAssertionsFail() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("fail"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
        pipe = new Each(pipe, AssertionLevel.STRICT, (Assertion)new AssertNotNull());
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), AssertionLevel.STRICT, (Assertion)new AssertMatches("^POST"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"method", "count"}));
        pipe = new Every(pipe, AssertionLevel.STRICT, (GroupAssertion)new AssertGroupSizeEquals(0L));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        try {
            flow.complete();
            AppliedAssertionsPlatformTest.fail((String)"no assertions thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupAssertionsRemoval() throws Exception {
        this.runGroupAssertions(AssertionLevel.NONE, AssertionLevel.STRICT, true);
        this.runGroupAssertions(AssertionLevel.VALID, AssertionLevel.STRICT, true);
        this.runGroupAssertions(AssertionLevel.STRICT, AssertionLevel.STRICT, false);
        this.runGroupAssertions(AssertionLevel.NONE, AssertionLevel.VALID, true);
        this.runGroupAssertions(AssertionLevel.VALID, AssertionLevel.VALID, false);
    }

    private void runGroupAssertions(AssertionLevel planLevel, AssertionLevel setLevel, boolean pass) throws IOException {
        Flow flow;
        block4: {
            this.getPlatform().copyFromLocal(InputData.inputFileApache);
            Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
            Tap sink = this.getPlatform().getTextFile(this.getOutputPath("group/" + planLevel + "/" + setLevel), SinkMode.REPLACE);
            Pipe pipe = new Pipe("test");
            pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)this.apacheCommonParser);
            pipe = new Each(pipe, setLevel, (Assertion)new AssertNotNull());
            pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
            pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), setLevel, (Assertion)new AssertMatches("^POST"));
            pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
            pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"method", "count"}));
            pipe = new Every(pipe, setLevel, (GroupAssertion)new AssertGroupSizeEquals(0L));
            Map<Object, Object> properties = this.getPlatform().getProperties();
            FlowConnectorProps.setAssertionLevel(properties, (AssertionLevel)planLevel);
            flow = this.getPlatform().getFlowConnector(properties).connect(source, sink, pipe);
            try {
                flow.complete();
                if (!pass) {
                    AppliedAssertionsPlatformTest.fail((String)String.format("no assertions thrown %s %s %s", planLevel, setLevel, pass));
                }
            }
            catch (Exception exception) {
                if (!pass) break block4;
                AppliedAssertionsPlatformTest.fail((String)String.format("assertion thrown %s %s %s", planLevel, setLevel, pass));
            }
        }
        if (pass) {
            AppliedAssertionsPlatformTest.validateLength((Flow)flow, (int)1, null);
        }
    }
}

