/*
 * Decompiled with CFR 0.152.
 */
package cascading.function;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.Insert;
import cascading.operation.function.SetValue;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexSplitter;
import cascading.operation.text.FieldFormatter;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import data.InputData;
import java.io.IOException;
import java.util.List;
import org.junit.Test;

public class FunctionPlatformTest
extends PlatformTestCase {
    @Test
    public void testInsert() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileApache200);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache200);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("insert"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("apache");
        pipe = new Each(pipe, (Function)new Insert(new Fields(new Comparable[]{"A", "B"}), new Object[]{"a", "b"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"A"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FunctionPlatformTest.validateLength((Flow)flow, (int)200);
        List results = FunctionPlatformTest.getSinkAsList((Flow)flow);
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"a\tb"})));
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"a\tb"})));
    }

    @Test
    public void testFieldFormatter() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("formatter"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("formatter");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"a", "b"}), "\\s"));
        pipe = new Each(pipe, (Function)new FieldFormatter(new Fields(new Comparable[]{"result"}), "%s and %s"));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FunctionPlatformTest.validateLength((Flow)flow, (int)5);
        List results = FunctionPlatformTest.getSinkAsList((Flow)flow);
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1 and A"})));
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"2 and B"})));
    }

    @Test
    public void testSetValue() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("setvalue"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("setvalue");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), "\\s"));
        pipe = new Each(pipe, (Function)new SetValue(new Fields(new Comparable[]{"result"}), (Filter)new RegexFilter("[A-C]")));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FunctionPlatformTest.validateLength((Flow)flow, (int)5);
        List results = FunctionPlatformTest.getSinkAsList((Flow)flow);
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"true"})));
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"true"})));
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"true"})));
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"false"})));
        FunctionPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"false"})));
    }
}

