/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowConnector;
import cascading.operation.Aggregator;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.operation.aggregator.First;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.pipe.assembly.AggregateBy;
import cascading.pipe.assembly.CountBy;
import cascading.pipe.assembly.SumBy;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.junit.Test;

public class SubAssemblyPlatformTest
extends PlatformTestCase {
    @Test
    public void testPipeAssembly() {
        TestAssembly pipe = new TestAssembly("test");
        pipe = new GroupBy((Pipe)pipe, new Fields(new Comparable[]{"ip"}));
        Tap source = this.getPlatform().getTextFile("foo");
        Tap sink = this.getPlatform().getTextFile("foo/split1", SinkMode.REPLACE);
        List steps = this.getPlatform().getFlowConnector().connect(source, sink, (Pipe)pipe).getFlowSteps();
        SubAssemblyPlatformTest.assertEquals((String)"not equal: steps.size()", (int)1, (int)steps.size());
    }

    @Test
    public void testBadSubAssembly() {
        TestAssembly pipe = new TestAssembly("test", true);
        Tap source = this.getPlatform().getTextFile("foo");
        Tap sink = this.getPlatform().getTextFile("foo/split1", SinkMode.REPLACE);
        try {
            this.getPlatform().getFlowConnector().connect(source, sink, (Pipe)pipe);
            SubAssemblyPlatformTest.fail((String)"did not throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPipeAssemblySplit() {
        TestAssembly pipe = new TestAssembly("test");
        GroupBy pipe1 = new GroupBy("left", (Pipe)pipe, new Fields(new Comparable[]{"ip"}));
        GroupBy pipe2 = new GroupBy("right", (Pipe)pipe, new Fields(new Comparable[]{"ip"}));
        Tap source = this.getPlatform().getTextFile("foo");
        Tap sink1 = this.getPlatform().getTextFile("foo/split1", SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile("foo/split2", SinkMode.REPLACE);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("test", source);
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put("left", sink1);
        sinks.put("right", sink2);
        List steps = this.getPlatform().getFlowConnector().connect(sources, sinks, new Pipe[]{pipe1, pipe2}).getFlowSteps();
        if (this.getPlatform().isMapReduce()) {
            SubAssemblyPlatformTest.assertEquals((String)"not equal: steps.size()", (int)2, (int)steps.size());
        }
    }

    @Test
    public void testNestedAssembliesAccessors() throws IOException {
        Object pipe = new Pipe("test");
        pipe = new SecondAssembly((Pipe)pipe);
        Pipe[] allPrevious = pipe.getPrevious();
        SubAssemblyPlatformTest.assertEquals((String)"wrong number of previous", (int)1, (int)allPrevious.length);
        Pipe[] heads = pipe.getHeads();
        SubAssemblyPlatformTest.assertEquals((String)"wrong number of heads", (int)1, (int)heads.length);
        for (Pipe head : heads) {
            SubAssemblyPlatformTest.assertFalse((boolean)(head instanceof SubAssembly));
        }
    }

    @Test
    public void testNestedAssemblies() throws IOException {
        Tap source = this.getPlatform().getTextFile("foo");
        Tap sink = this.getPlatform().getTextFile("foo/split1", SinkMode.REPLACE);
        Object pipe = new Pipe("test");
        pipe = new SecondAssembly((Pipe)pipe);
        pipe = new GroupBy(pipe, Fields.size((int)1));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        List steps = flow.getFlowSteps();
        if (this.getPlatform().isMapReduce()) {
            SubAssemblyPlatformTest.assertEquals((String)"wrong size", (int)2, (int)steps.size());
        }
    }

    @Test
    public void testAssemblyPlanFailure() {
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"date", "size"}), "\t", "someinput");
        Tap sink = this.getPlatform().getTextFile("outpath", SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile("outpath2", SinkMode.REPLACE);
        Pipe assembly = new Pipe("assembly");
        Pipe assembly2 = new Pipe("assembly2", assembly);
        Fields groupingFields = new Fields(new Comparable[]{"date"});
        assembly = new AggregateBy(assembly, groupingFields, new AggregateBy[]{new SumBy(new Fields(new Comparable[]{"size"}), new Fields(new Comparable[]{"size"}), Double.TYPE), new SumBy(new Fields(new Comparable[]{"size"}), new Fields(new Comparable[]{"size2"}), Double.TYPE), new CountBy(new Fields(new Comparable[]{"sizes"})), new CountBy(new Fields(new Comparable[]{"sizes2"}))});
        assembly2 = new AggregateBy(assembly2, groupingFields, new AggregateBy[]{new SumBy(new Fields(new Comparable[]{"size"}), new Fields(new Comparable[]{"size"}), Double.TYPE), new SumBy(new Fields(new Comparable[]{"size"}), new Fields(new Comparable[]{"size2"}), Double.TYPE), new CountBy(new Fields(new Comparable[]{"sizes"})), new CountBy(new Fields(new Comparable[]{"sizes2"}))});
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put("assembly", sink);
        sinks.put("assembly2", sink2);
        FlowConnector flowConnector = this.getPlatform().getFlowConnector();
        try {
            Flow flow = flowConnector.connect("test", source, sinks, new Pipe[]{assembly2, assembly});
            SubAssemblyPlatformTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class SecondAssembly
    extends SubAssembly {
        public SecondAssembly(Pipe previous) {
            Object pipe = new Pipe("second", previous);
            pipe = new Each(pipe, (Function)new Identity());
            pipe = new FirstAssembly((Pipe)pipe);
            this.setTails(new Pipe[]{pipe});
        }
    }

    private static class FirstAssembly
    extends SubAssembly {
        public FirstAssembly(Pipe previous) {
            Pipe pipe = new Pipe("first", previous);
            pipe = new Each(pipe, (Function)new Identity());
            pipe = new GroupBy(pipe, Fields.ALL);
            pipe = new Every(pipe, (Aggregator)new First(), Fields.RESULTS);
            this.setTails(new Pipe[]{pipe});
        }
    }

    private static class TestAssembly
    extends SubAssembly {
        public TestAssembly(String name) {
            this(name, false);
        }

        public TestAssembly(String name, boolean bad) {
            Pipe pipe = new Pipe(name);
            pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
            if (!bad) {
                this.setTails(new Pipe[]{pipe});
            }
        }
    }
}

