/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import data.InputData;
import java.net.URL;
import org.junit.Test;

public class ClasspathPlatformTest
extends PlatformTestCase {
    public ClasspathPlatformTest() {
        super(true);
    }

    @Test
    public void testSimpleClasspath() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new TestFunction(), Fields.RESULTS);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("classpath"), SinkMode.REPLACE);
        FlowDef flowDef = FlowDef.flowDef().addSource("test", source).addTailSink(pipe, sink).addToClassPath(InputData.testClasspathJar);
        Flow flow = this.getPlatform().getFlowConnector().connect(flowDef);
        flow.complete();
        ClasspathPlatformTest.validateLength((Flow)flow, (int)10);
    }

    public static class TestFunction
    extends BaseOperation
    implements Function {
        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("apache.10.txt");
            if (resource == null) {
                throw new RuntimeException("cannot find resource");
            }
            functionCall.getOutputCollector().add(functionCall.getArguments());
        }
    }
}

