/*
 * Decompiled with CFR 0.152.
 */
package cascading.detail;

import cascading.PlatformTestCase;
import cascading.detail.AssemblyFactory;
import cascading.flow.Flow;
import cascading.pipe.Pipe;
import cascading.platform.PlatformSuite;
import cascading.platform.TestPlatform;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.util.Util;
import data.InputData;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import junit.framework.TestSuite;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PlatformSuite
public abstract class PipeAssemblyTestBase
extends PlatformTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PipeAssemblyTestBase.class);
    static Fields[] OP_ARGS_FIELDS = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(-1)}), new Fields(new Comparable[]{Integer.valueOf(0)}), Fields.ALL};
    static Fields[] OP_DECL_FIELDS = new Fields[]{new Fields(new Comparable[]{"field"}), Fields.UNKNOWN, Fields.VALUES, Fields.ARGS};
    static Fields[] OP_SELECT_FIELDS = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(-1)}), new Fields(new Comparable[]{"field"}), Fields.RESULTS, Fields.ALL, Fields.REPLACE, Fields.SWAP};
    static final String OP_VALUE = "value";
    static Fields[] LHS_ARGS_FIELDS = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(-1)}), Fields.ALL};
    static Fields[] LHS_DECL_FIELDS = new Fields[]{new Fields(new Comparable[]{"field"}), Fields.UNKNOWN, Fields.ARGS};
    static Fields[] LHS_SELECT_FIELDS = new Fields[]{Fields.RESULTS, Fields.ALL};
    static final String LHS_VALUE = "value";
    static Fields[] RHS_ARGS_FIELDS = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(-1)}), new Fields(new Comparable[]{Integer.valueOf(0)}), Fields.ALL};
    static Fields[] RHS_DECL_FIELDS = new Fields[]{new Fields(new Comparable[]{"field2"}), Fields.UNKNOWN, Fields.VALUES, Fields.ARGS};
    static Fields[] RHS_SELECT_FIELDS = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(-1)}), new Fields(new Comparable[]{"field2"}), new Fields(new Comparable[]{"field"}), Fields.RESULTS, Fields.ALL};
    static final String RHS_VALUE = "value2";
    private String key;
    Properties properties;
    private Pipe pipe;
    Fields argFields;
    Fields declFields;
    Fields selectFields;
    Tuple resultTuple;
    int resultLength;

    public static void makeSuites(TestPlatform testPlatform, Properties properties, Map<String, Pipe> pipes, TestSuite suite, Class type) throws IllegalAccessException, InvocationTargetException, InstantiationException, IOException, ClassNotFoundException {
        for (String name : pipes.keySet()) {
            if (PipeAssemblyTestBase.isUNDEFINED(properties, name)) {
                LOG.debug("skipping: {}", (Object)name);
                continue;
            }
            String platformName = testPlatform.getName();
            String displayName = String.format("%s[%s]", name, platformName);
            PlatformTestCase platformTest = (PlatformTestCase)((Object)type.getConstructors()[0].newInstance(properties, displayName, name, pipes.get(name)));
            platformTest.installPlatform(testPlatform);
            suite.addTest((junit.framework.Test)platformTest);
        }
    }

    public static Properties loadProperties(String type) throws IOException {
        String path = PipeAssemblyTestBase.class.getPackage().getName().replace(".", "/") + "/" + type;
        InputStream input = PipeAssemblyTestBase.class.getClassLoader().getResourceAsStream(path);
        Properties properties = new Properties();
        properties.load(input);
        return properties;
    }

    static String runOnly(Properties properties) {
        return properties.getProperty("run.only");
    }

    private static boolean isUNDEFINED(Properties properties, String name) {
        return !properties.containsKey(name + ".ERROR") && !properties.containsKey(name + ".tuple");
    }

    public static Map<String, Pipe> buildOpPipes(String prefix, Pipe pipe, AssemblyFactory assemblyFactory, Fields[] args_fields, Fields[] decl_fields, Fields[] select_fields, String functionValue, String runOnly) {
        LinkedHashMap<String, Pipe> pipes = new LinkedHashMap<String, Pipe>();
        for (int arg = 0; arg < args_fields.length; ++arg) {
            Fields argFields = args_fields[arg];
            for (int decl = 0; decl < decl_fields.length; ++decl) {
                Fields declFields = decl_fields[decl];
                for (int select = 0; select < select_fields.length; ++select) {
                    Fields selectFields = select_fields[select];
                    String name = prefix != null ? prefix + "." + Util.join((Object[])Fields.fields((Fields[])new Fields[]{argFields, declFields, selectFields}), (String)"_") : Util.join((Object[])Fields.fields((Fields[])new Fields[]{argFields, declFields, selectFields}), (String)"_");
                    if (runOnly != null && !runOnly.equalsIgnoreCase(name)) continue;
                    pipes.put(name, assemblyFactory.createAssembly(pipe, argFields, declFields, functionValue, selectFields));
                }
            }
        }
        return pipes;
    }

    public PipeAssemblyTestBase(Properties properties, String displayName, String key, Pipe pipe) {
        this.setName(displayName);
        this.key = key;
        this.properties = properties;
        this.pipe = pipe;
        this.resultTuple = this.getResultTuple();
        this.resultLength = this.getResultLength();
    }

    Tuple getResultTuple() {
        return PipeAssemblyTestBase.parse((String)this.properties.get(this.key + ".tuple"));
    }

    static Tuple parse(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.replaceAll("^ *\\[*", "");
        string = string.replaceAll("\\]* *$", "");
        Scanner scanner = new Scanner(new StringReader(string));
        scanner.useDelimiter("(' *, *')|(^ *')|(' *$)");
        Tuple result = new Tuple();
        while (scanner.hasNext()) {
            if (scanner.hasNextInt()) {
                result.add((Comparable)Integer.valueOf(scanner.nextInt()));
                continue;
            }
            if (scanner.hasNextDouble()) {
                result.add((Comparable)Double.valueOf(scanner.nextDouble()));
                continue;
            }
            result.add((Comparable)((Object)scanner.next()));
        }
        scanner.close();
        return result;
    }

    boolean isWriteDOT() {
        return this.properties.containsKey(this.key + ".writedot");
    }

    int getResultLength() {
        return Integer.parseInt(this.properties.getProperty(this.key + ".length", this.properties.getProperty("default.length")));
    }

    boolean isError() {
        return this.properties.containsKey(this.key + ".ERROR");
    }

    @Test
    public void runTest() throws Exception {
        this.copyFromLocal(InputData.inputFileNums20);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileNums20);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath(this.key), SinkMode.REPLACE);
        Flow flow = null;
        try {
            flow = this.getPlatform().getFlowConnector().connect(source, sink, this.pipe);
            if (this.isWriteDOT()) {
                flow.writeDOT(this.getName() + ".dot");
            }
            flow.complete();
            if (this.isError()) {
                PipeAssemblyTestBase.fail((String)"did not throw asserted error");
            }
        }
        catch (Exception exception) {
            if (this.isError()) {
                return;
            }
            throw exception;
        }
        if (this.resultLength != -1) {
            PipeAssemblyTestBase.validateLength((Flow)flow, (int)this.resultLength);
        }
        TupleEntryIterator iterator = flow.openSink();
        Object result = ((TupleEntry)iterator.next()).getObject(1);
        if (this.resultTuple != null) {
            PipeAssemblyTestBase.assertEquals((String)"not equal: ", (Object)this.resultTuple.toString(), (Object)result);
        } else if (this.resultTuple == null) {
            PipeAssemblyTestBase.fail((String)("no result assertion made for:" + this.getName() + " with result: " + result));
        }
    }
}

