/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.Function;
import cascading.operation.assertion.AssertExpression;
import cascading.operation.text.DateParser;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.pipe.Merge;
import cascading.pipe.Pipe;
import cascading.pipe.joiner.InnerJoin;
import cascading.pipe.joiner.Joiner;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.type.DateType;
import data.InputData;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.junit.Test;

public class TypedFieldedPipesPlatformTest
extends PlatformTestCase {
    @Test
    public void testCoGroupIncomparableTypes() throws Exception {
        this.runJoinIncomparableTypes(false, true, false, false);
    }

    @Test
    public void testCoGroupComparableTypes() throws Exception {
        this.runJoinIncomparableTypes(false, true, true, false);
    }

    @Test
    public void testHashJoinIncomparableTypes() throws Exception {
        this.runJoinIncomparableTypes(false, false, false, false);
    }

    @Test
    public void testHashJoinComparableTypes() throws Exception {
        this.runJoinIncomparableTypes(false, false, true, false);
    }

    @Test
    public void testCoGroupIncomparableTypesDeclared() throws Exception {
        this.runJoinIncomparableTypes(false, true, false, true);
    }

    @Test
    public void testCoGroupComparableTypesDeclared() throws Exception {
        this.runJoinIncomparableTypes(false, true, true, true);
    }

    @Test
    public void testHashJoinIncomparableTypesDeclared() throws Exception {
        this.runJoinIncomparableTypes(false, false, false, true);
    }

    @Test
    public void testHashJoinComparableTypesDeclared() throws Exception {
        this.runJoinIncomparableTypes(false, false, true, true);
    }

    @Test
    public void testGroupByIncomparableTypes() throws Exception {
        this.runJoinIncomparableTypes(true, true, false, true);
    }

    @Test
    public void testGroupByComparableTypes() throws Exception {
        this.runJoinIncomparableTypes(true, true, true, true);
    }

    @Test
    public void testMergeIncomparableTypes() throws Exception {
        this.runJoinIncomparableTypes(true, false, false, true);
    }

    private void runJoinIncomparableTypes(boolean isMerge, boolean isGroup, boolean includeComparator, boolean isDeclared) throws Exception {
        Tap sink;
        block5: {
            this.getPlatform().copyFromLocal(InputData.inputFileLhs);
            this.getPlatform().copyFromLocal(InputData.inputFileRhs);
            HashMap<String, Tap> sources = new HashMap<String, Tap>();
            Type[] lhsTypes = new Class[]{Long.TYPE, String.class};
            Type[] rhsTypes = new Class[]{Short.TYPE, Character.TYPE};
            Fields declaredFields = isDeclared ? new Fields(new Comparable[]{"numLHS", "charLHS"}).append(new Fields(new Comparable[]{"numRHS", "charRHS"})) : null;
            Fields lhsFields = new Fields(new Comparable[]{"num", "char"}).applyTypes(lhsTypes);
            Fields rhsFields = new Fields(new Comparable[]{"num" + (isDeclared ? "" : "1"), "char" + (isDeclared ? "" : "1")}).applyTypes(rhsTypes);
            sources.put("lhs", this.getPlatform().getDelimitedFile(lhsFields, " ", InputData.inputFileLhs, SinkMode.KEEP));
            sources.put("rhs", this.getPlatform().getDelimitedFile(rhsFields, " ", InputData.inputFileRhs, SinkMode.KEEP));
            sink = this.getPlatform().getDelimitedFile(Fields.ALL, true, "\t", "\"", this.getOutputPath(this.getTestName()), SinkMode.REPLACE);
            Pipe pipeLower = new Pipe("lhs");
            Pipe pipeUpper = new Pipe("rhs");
            Fields numLHS = new Fields(new Comparable[]{"num"});
            if (includeComparator) {
                numLHS.setComparator((Comparable)Integer.valueOf(0), Collections.reverseOrder());
            }
            Fields numRHS = new Fields(new Comparable[]{"num" + (isDeclared ? "" : "1")});
            Object join = isMerge && isGroup ? new GroupBy(Pipe.pipes((Pipe[])new Pipe[]{pipeLower, pipeUpper}), numLHS) : (!isMerge && isGroup ? new CoGroup(pipeLower, numLHS, pipeUpper, numRHS, declaredFields, (Joiner)new InnerJoin()) : (isMerge && !isGroup ? new Merge(new Pipe[]{pipeLower, pipeUpper}) : new HashJoin(pipeLower, numLHS, pipeUpper, numRHS, declaredFields, (Joiner)new InnerJoin())));
            Flow flow = null;
            try {
                flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)join);
                if (!includeComparator) {
                    TypedFieldedPipesPlatformTest.fail((String)"should fail during planning");
                }
            }
            catch (Exception exception) {
                if (!includeComparator) break block5;
                exception.printStackTrace();
                TypedFieldedPipesPlatformTest.fail((String)("should not fail during planning: " + exception.getMessage()));
            }
        }
        if (!isMerge && includeComparator) {
            Object[] types = sink.getSinkFields().getTypesClasses();
            TypedFieldedPipesPlatformTest.assertTrue((boolean)Arrays.equals(types, new Class[]{Long.TYPE, String.class, Short.TYPE, Character.TYPE}));
        }
    }

    @Test
    public void testFieldTypeCheck() throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileApacheClean);
        DateType dateType = new DateType("dd/MMM/yyyy:HH:mm:ss Z", TimeZone.getDefault(), Locale.US);
        Type[] lhsTypes = new Type[]{String.class, String.class, String.class, dateType, String.class, Integer.TYPE, Long.TYPE, String.class, String.class, String.class};
        Fields lhsFields = new Fields(new Comparable[]{"ip", "client", "user", "date", "request", "code", "bytes", "referrer", "agent", "na"});
        lhsFields = lhsFields.applyTypes(lhsTypes);
        Tap inputLhs = this.getPlatform().getDelimitedFile(lhsFields, false, true, ",", "\"", null, InputData.inputFileApacheClean, SinkMode.KEEP);
        Type[] rhsTypes = new Type[]{String.class, String.class, String.class, String.class, String.class, Integer.TYPE, Long.TYPE, String.class, String.class, String.class};
        Fields rhsFields = new Fields(new Comparable[]{"ip", "client", "user", "date", "request", "code", "bytes", "referrer", "agent", "na"});
        rhsFields = rhsFields.applyTypes(rhsTypes);
        Tap inputRhs = this.getPlatform().getDelimitedFile(rhsFields, false, true, ",", "\"", null, InputData.inputFileApacheClean, SinkMode.KEEP);
        Tap output = this.getPlatform().getDelimitedFile(Fields.UNKNOWN, true, true, ",", "\"", null, this.getOutputPath(this.getTestName()), SinkMode.REPLACE);
        Pipe lhsPipe = new Pipe("lhs");
        lhsPipe = new Each(lhsPipe, new Fields(new Comparable[]{"date"}), AssertionLevel.STRICT, (Assertion)new AssertExpression("date instanceof Long", Object.class));
        Pipe rhsPipe = new Pipe("rhs");
        Class<Long> type = this.getPlatform().isMapReduce() ? Long.TYPE : Long.class;
        rhsPipe = new Each(rhsPipe, new Fields(new Comparable[]{"date"}), (Function)new DateParser(new Fields((Comparable)((Object)"date"), type), TimeZone.getDefault(), Locale.US, "dd/MMM/yyyy:HH:mm:ss Z"), Fields.REPLACE);
        rhsPipe = new Each(rhsPipe, new Fields(new Comparable[]{"date"}), AssertionLevel.STRICT, (Assertion)new AssertExpression("date instanceof Long", Object.class));
        Fields declared = lhsFields.append(Fields.mask((Fields)rhsFields, (Fields)lhsFields));
        CoGroup pipe = new CoGroup(lhsPipe, new Fields(new Comparable[]{"date"}), rhsPipe, new Fields(new Comparable[]{"date"}), declared);
        FlowDef flowDef = FlowDef.flowDef().addSource(lhsPipe, inputLhs).addSource(rhsPipe, inputRhs).addTailSink((Pipe)pipe, output);
        Map<Object, Object> properties = this.getProperties();
        properties.put("cascading.serialization.types.required", "true");
        Flow flow = this.getPlatform().getFlowConnector(properties).connect(flowDef);
        flow.complete();
        TypedFieldedPipesPlatformTest.validateLength((Flow)flow, (int)14, (int)20);
    }
}

