/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.CascadingException;
import cascading.PlatformTestCase;
import cascading.TestFailAggregator;
import cascading.TestFunction;
import cascading.cascade.Cascades;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.operation.Aggregator;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.Function;
import cascading.operation.aggregator.Count;
import cascading.operation.assertion.AssertNotEquals;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.property.ConfigDef;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TrapProps;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryIterator;
import data.InputData;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.junit.Test;

public class TrapPlatformTest
extends PlatformTestCase {
    public TrapPlatformTest() {
        super(true, 4, 4);
    }

    @Test
    public void testTrapNone() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("none/tap"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile(this.getOutputPath("none/trap"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)8, null);
        try {
            flow.openTrap();
            TrapPlatformTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testTrapEachAll() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("all/tap"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile(this.getOutputPath("all/trap"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)0, null);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)10);
    }

    @Test
    public void testTrapEachAllSequence() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTabDelimitedFile(Fields.ALL, this.getOutputPath("allseq/tap"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTabDelimitedFile(Fields.ALL, this.getOutputPath("allseq/trap"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)0, null);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)10);
    }

    @Test
    public void testTrapEveryAllAtStart() throws Exception {
        this.runTrapEveryAll(0, "everystart", 8);
    }

    @Test
    public void testTrapEveryAllAtAggregate() throws Exception {
        this.runTrapEveryAll(1, "everyaggregate", 10);
    }

    @Test
    public void testTrapEveryAllAtComplete() throws Exception {
        this.runTrapEveryAll(2, "everycomplete", 8);
    }

    private void runTrapEveryAll(int failAt, String path, int failSize) throws IOException {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        pipe = new Every(pipe, (Aggregator)new TestFailAggregator(new Fields(new Comparable[]{"fail"}), failAt), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath(path + "/tap"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile(this.getOutputPath(path + "/trap"), SinkMode.REPLACE);
        Map traps = Cascades.tapsMap((String)"reduce", (Tap)trap);
        Flow flow = this.getPlatform().getFlowConnector().connect("trap test", source, sink, traps, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)0, null);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)failSize);
    }

    @Test
    public void testTrapEachAllChained() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Function)new TestFunction(new Fields(new Comparable[]{"test"}), new Tuple(new Object[]{1}), 1), Fields.ALL);
        pipe = new Each(pipe, (Function)new TestFunction(new Fields(new Comparable[]{"test2"}), new Tuple(new Object[]{2}), 2), Fields.ALL);
        pipe = new Each(pipe, (Function)new TestFunction(new Fields(new Comparable[]{"test3"}), new Tuple(new Object[]{3}), 3), Fields.ALL);
        pipe = new Each(pipe, (Function)new TestFunction(new Fields(new Comparable[]{"test4"}), new Tuple(new Object[]{4}), 4), Fields.ALL);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("allchain/tap-nondeterministic"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile(this.getOutputPath("allchain/trap-nondeterministic"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)6, null);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)4);
    }

    @Test
    public void testTrapEachEveryAllChained() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, AssertionLevel.VALID, (Assertion)new AssertNotEquals(new Object[]{"75.185.76.245"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, AssertionLevel.VALID, (Assertion)new AssertNotEquals(new Object[]{"68.46.103.112"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, AssertionLevel.VALID, (Assertion)new AssertNotEquals(new Object[]{"76.197.151.0"}));
        pipe = new Each(pipe, AssertionLevel.VALID, (Assertion)new AssertNotEquals(new Object[]{"12.215.138.88"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("eacheverychain/tap"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile(this.getOutputPath("eacheverychain/trap"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)6, null);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)4);
    }

    @Test
    public void testTrapToSequenceFile() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("seq/tap"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTabDelimitedFile(new Fields(new Comparable[]{"ip"}), this.getOutputPath("seq/trap"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)0, null);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)10);
    }

    @Test
    public void testTrapTapSourceSink() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Scheme scheme = this.getPlatform().getTestFailScheme();
        Tap source = this.getPlatform().getTap(scheme, InputData.inputFileApache, SinkMode.KEEP);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTap(scheme, this.getOutputPath("trapsourcesink/sink"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("trapsourcesink/trap"), SinkMode.REPLACE);
        Map<Object, Object> properties = this.getProperties();
        this.getPlatform().setNumMapTasks(properties, 1);
        this.getPlatform().setNumReduceTasks(properties, 1);
        this.getPlatform().setNumGatherPartitionTasks(properties, 1);
        Flow flow = this.getPlatform().getFlowConnector(properties).connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTapForRead(this.getPlatform().getTextFile(sink.getIdentifier())), (int)7);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)2, (Pattern)Pattern.compile("bad data"));
    }

    @Test
    public void testTrapNoOperation() throws Exception {
        this.getPlatform().copyFromLocal(InputData.testDelimitedProblematic);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"id", "name"}).applyTypes(new Type[]{Integer.TYPE, String.class}), ",", InputData.testDelimitedProblematic);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"id", "name"}).applyTypes(new Type[]{Integer.TYPE, String.class}), ",", this.getOutputPath(this.getTestName()), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile(this.getOutputPath(this.getTestName() + "_trap"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("copy");
        FlowDef flowDef = FlowDef.flowDef().addSource(pipe, source).addTailSink(pipe, sink).addTrap(pipe, trap);
        Flow flow = this.getPlatform().getFlowConnector().connect(flowDef);
        flow.complete();
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)1);
    }

    @Test
    public void testTrapDiagnostics() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("diag/tap-nondeterministic"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTabDelimitedFile(Fields.ALL, this.getOutputPath("diag/trap-nondeterministic"), SinkMode.REPLACE);
        Properties properties = this.getProperties();
        properties = TrapProps.trapProps().recordAllDiagnostics().buildProperties(properties);
        Flow flow = this.getPlatform().getFlowConnector(properties).connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)0);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)10, (int)4, (Pattern)Pattern.compile(".*TrapPlatformTest.*"));
    }

    @Test
    public void testTrapDiagnosticsLocalConfig() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("diagconfigdef/tap-nondeterministic"), SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTabDelimitedFile(Fields.ALL, this.getOutputPath("diagconfigdef/trap-nondeterministic"), SinkMode.REPLACE);
        Map<Object, Object> properties = this.getProperties();
        TrapProps.trapProps().recordAllDiagnostics().setProperties(trap.getConfigDef(), ConfigDef.Mode.DEFAULT);
        Flow flow = this.getPlatform().getFlowConnector(properties).connect("trap test", source, sink, trap, pipe);
        flow.complete();
        TrapPlatformTest.validateLength((Flow)flow, (int)0);
        TrapPlatformTest.validateLength((TupleEntryIterator)flow.openTrap(), (int)10, (int)4, (Pattern)Pattern.compile(".*TrapPlatformTest.*"));
    }

    @Test(expected=CascadingException.class)
    public void testTrapFailure() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Scheme scheme = this.getPlatform().getTestFailScheme();
        Tap trap2 = this.getPlatform().getTap(scheme, this.getOutputPath("trapFailure/badTrap"), SinkMode.REPLACE);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("trapFailure/tap"), SinkMode.REPLACE);
        Each pipe = new Each(new Pipe("firstPipe"), new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(new Pipe("secondPipe", (Pipe)pipe), new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        Tap trap1 = this.getPlatform().getTextFile(this.getOutputPath("trapFailure/firstTrap"), SinkMode.REPLACE);
        FlowDef flowDef = FlowDef.flowDef().addSource("firstPipe", source).addTrap("firstPipe", trap1).addTrap("secondPipe", trap2).addTail((Pipe)pipe).addSink((Pipe)pipe, sink);
        Flow flow = this.getPlatform().getFlowConnector().connect(flowDef);
        flow.complete();
    }
}

