/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.TestAggregator;
import cascading.TestConstants;
import cascading.TestFunction;
import cascading.cascade.Cascades;
import cascading.flow.Flow;
import cascading.operation.Aggregator;
import cascading.operation.Debug;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.operation.Insert;
import cascading.operation.NoOp;
import cascading.operation.aggregator.Count;
import cascading.operation.aggregator.First;
import cascading.operation.expression.ExpressionFunction;
import cascading.operation.filter.And;
import cascading.operation.function.UnGroup;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexParser;
import cascading.operation.regex.RegexSplitter;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Merge;
import cascading.pipe.Pipe;
import cascading.tap.MultiSourceTap;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Hasher;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryIterator;
import data.InputData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Test;

public class FieldedPipesPlatformTest
extends PlatformTestCase {
    public FieldedPipesPlatformTest() {
        super(true, 5, 3);
    }

    @Test
    public void testSimpleGroup() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("simple"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((TupleEntryIterator)flow.openSource(), (int)10);
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)8, null);
    }

    @Test
    public void testSimpleChain() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(new Fields(new Comparable[]{"count1"})));
        pipe = new Every(pipe, (Aggregator)new Count(new Fields(new Comparable[]{"count2"})));
        pipe = new Every(pipe, (Aggregator)new Count(new Fields(new Comparable[]{"count3"})));
        pipe = new Every(pipe, (Aggregator)new Count(new Fields(new Comparable[]{"count4"})));
        Tap sink = this.getPlatform().getTabDelimitedFile(Fields.ALL, this.getOutputPath("simplechain"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)8, (int)5);
    }

    @Test
    public void testChainEndingWithEach() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(new Fields(new Comparable[]{"count1"})));
        pipe = new Every(pipe, (Aggregator)new Count(new Fields(new Comparable[]{"count2"})));
        pipe = new Each(pipe, new Fields(new Comparable[]{"count1", "count2"}), (Function)new ExpressionFunction(new Fields(new Comparable[]{"sum"}), "count1 + count2", Integer.TYPE), Fields.ALL);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("chaineach"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)8, null);
    }

    @Test
    public void testNoGroup() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, (Function)new RegexSplitter("\\s+"), new Fields(new Comparable[]{Integer.valueOf(1)}));
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("nogroup"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10, null);
        List results = FieldedPipesPlatformTest.getSinkAsList((Flow)flow);
        FieldedPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"75.185.76.245"})));
    }

    @Test
    public void testCopy() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("copy"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10, null);
    }

    @Test
    public void testSimpleMerge() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(InputData.inputFileUpper);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("simplemerge"), SinkMode.REPLACE);
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        GroupBy splice = new GroupBy("merge", Pipe.pipes((Pipe[])new Pipe[]{pipeLower, pipeUpper}), new Fields(new Comparable[]{"num"}), null, false);
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10);
        List results = FieldedPipesPlatformTest.getSinkAsList((Flow)flow);
        FieldedPipesPlatformTest.assertTrue((String)"missing value", (boolean)results.contains(new Tuple(new Object[]{"1\ta"})));
        FieldedPipesPlatformTest.assertTrue((String)"missing value", (boolean)results.contains(new Tuple(new Object[]{"1\tA"})));
        FieldedPipesPlatformTest.assertTrue((String)"missing value", (boolean)results.contains(new Tuple(new Object[]{"2\tb"})));
        FieldedPipesPlatformTest.assertTrue((String)"missing value", (boolean)results.contains(new Tuple(new Object[]{"2\tB"})));
        FieldedPipesPlatformTest.assertTrue((String)"missing value", (boolean)results.contains(new Tuple(new Object[]{"3\tc"})));
        FieldedPipesPlatformTest.assertTrue((String)"missing value", (boolean)results.contains(new Tuple(new Object[]{"3\tC"})));
    }

    @Test
    public void testSimpleMergeThree() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        this.getPlatform().copyFromLocal(InputData.inputFileLowerOffset);
        Tap sourceLower = this.getPlatform().getTextFile(InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(InputData.inputFileUpper);
        Tap sourceLowerOffset = this.getPlatform().getTextFile(InputData.inputFileLowerOffset);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        sources.put("offset", sourceLowerOffset);
        Tap sink = this.getPlatform().getDelimitedFile(Fields.ALL, "\t", this.getOutputPath("simplemergethree"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeOffset = new Each(new Pipe("offset"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        GroupBy splice = new GroupBy("merge", Pipe.pipes((Pipe[])new Pipe[]{pipeLower, pipeUpper, pipeOffset}), new Fields(new Comparable[]{"num"}), new Fields(new Comparable[]{"char"}));
        splice = new Every((Pipe)splice, new Fields(new Comparable[]{"char"}), (Aggregator)new First(new Fields(new Comparable[]{"first"})));
        splice = new Each((Pipe)splice, new Fields(new Comparable[]{"num", "first"}), (Function)new Identity());
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)6);
        List tuples = FieldedPipesPlatformTest.getSinkAsList((Flow)flow);
        FieldedPipesPlatformTest.assertTrue((boolean)tuples.contains(new Tuple(new Object[]{"1", "A"})));
        FieldedPipesPlatformTest.assertTrue((boolean)tuples.contains(new Tuple(new Object[]{"2", "B"})));
        FieldedPipesPlatformTest.assertTrue((boolean)tuples.contains(new Tuple(new Object[]{"3", "C"})));
        FieldedPipesPlatformTest.assertTrue((boolean)tuples.contains(new Tuple(new Object[]{"4", "D"})));
        FieldedPipesPlatformTest.assertTrue((boolean)tuples.contains(new Tuple(new Object[]{"5", "E"})));
        FieldedPipesPlatformTest.assertTrue((boolean)tuples.contains(new Tuple(new Object[]{"6", "c"})));
    }

    @Test
    public void testSameSourceMerge() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        Tap sourceLower = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"num", "char"}), " ", InputData.inputFileLower);
        HashMap sources = new HashMap();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceLower);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath(), SinkMode.REPLACE);
        Pipe pipeLower = new Pipe("lower");
        Pipe pipeUpper = new Pipe("upper");
        GroupBy splice = new GroupBy("merge", Pipe.pipes((Pipe[])new Pipe[]{pipeLower, pipeUpper}), new Fields(new Comparable[]{"num"}), null, false);
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10);
        List results = FieldedPipesPlatformTest.getSinkAsList((Flow)flow);
        FieldedPipesPlatformTest.assertEquals((String)"missing value", (int)2, (int)Collections.frequency(results, new Tuple(new Object[]{"1\ta"})));
        FieldedPipesPlatformTest.assertEquals((String)"missing value", (int)2, (int)Collections.frequency(results, new Tuple(new Object[]{"2\tb"})));
        FieldedPipesPlatformTest.assertEquals((String)"missing value", (int)2, (int)Collections.frequency(results, new Tuple(new Object[]{"3\tc"})));
    }

    @Test
    public void testSameSourceMergeThreeChainGroup() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        Tap sourceLower = this.getPlatform().getTextFile(InputData.inputFileLower);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("split", sourceLower);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("samemergethreechaingroup"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Pipe pipe = new Pipe("split");
        Each pipeLower = new Each(new Pipe("lower", pipe), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper", pipe), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeOffset = new Each(new Pipe("offset", pipe), new Fields(new Comparable[]{"line"}), (Function)splitter);
        GroupBy splice = new GroupBy(Pipe.pipes((Pipe[])new Pipe[]{pipeLower, pipeUpper}), new Fields(new Comparable[]{"num"}));
        splice = new GroupBy(Pipe.pipes((Pipe[])new Pipe[]{splice, pipeOffset}), new Fields(new Comparable[]{"num"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        if (this.getPlatform().isMapReduce()) {
            FieldedPipesPlatformTest.assertEquals((String)"wrong num jobs", (int)2, (int)flow.getFlowSteps().size());
        }
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)15);
    }

    @Test
    public void testUnGroup() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileJoined);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileJoined);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("ungrouped"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower", "upper"})));
        pipe = new Each(pipe, (Function)new UnGroup(new Fields(new Comparable[]{"num", "char"}), new Fields(new Comparable[]{"num"}), Fields.fields((Fields[])new Fields[]{new Fields(new Comparable[]{"lower"}), new Fields(new Comparable[]{"upper"})})));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10);
    }

    @Test
    public void testUnGroupAnon() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileJoined);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileJoined);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("ungroupedanon"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num", "lower", "upper"})));
        pipe = new Each(pipe, (Function)new UnGroup(new Fields(new Comparable[]{"num"}), Fields.fields((Fields[])new Fields[]{new Fields(new Comparable[]{"lower"}), new Fields(new Comparable[]{"upper"})})));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10);
    }

    @Test
    public void testUnGroupBySize() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileJoinedExtra);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileJoinedExtra);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("ungrouped_size"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexSplitter(new Fields(new Comparable[]{"num1", "num2", "lower", "upper"})));
        pipe = new Each(pipe, (Function)new UnGroup(new Fields(new Comparable[]{"num1", "num2", "char"}), new Fields(new Comparable[]{"num1", "num2"}), 1));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        List tuples = FieldedPipesPlatformTest.asList((Flow)flow, (Tap)sink);
        FieldedPipesPlatformTest.assertEquals((int)10, (int)tuples.size());
        ArrayList<Object> values = new ArrayList<Object>();
        for (Tuple tuple : tuples) {
            values.add(tuple.getObject(1));
        }
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("1\t1\ta"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("1\t1\tA"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("2\t2\tb"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("2\t2\tB"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("3\t3\tc"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("3\t3\tC"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("4\t4\td"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("4\t4\tD"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("5\t5\te"));
        FieldedPipesPlatformTest.assertTrue((boolean)values.contains("5\t5\tE"));
    }

    @Test
    public void testFilter() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("filter"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexFilter filter = new RegexFilter("^68.*");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)filter);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)3);
    }

    @Test
    public void testLogicFilter() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("logicfilter"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        And filter = new And(new Filter[]{new RegexFilter("^68.*$"), new RegexFilter("^1000.*$")});
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)filter);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)3);
    }

    @Test
    public void testFilterComplex() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("filtercomplex"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)TestConstants.APACHE_COMMON_PARSER);
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^POST"));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Function)new Identity(new Fields(new Comparable[]{"value"})), Fields.ALL);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"value"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"value", "count"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, null);
    }

    @Test
    public void testFilterAll() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("filterall"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        String regex = "^([^ ]*) +[^ ]* +[^ ]* +\\[([^]]*)\\] +\\\"([^ ]*) ([^ ]*) [^ ]*\\\" ([^ ]*) ([^ ]*).*$";
        Fields fieldDeclaration = new Fields(new Comparable[]{"ip", "time", "method", "event", "status", "size"});
        int[] groups = new int[]{1, 2, 3, 4, 5, 6};
        RegexParser function = new RegexParser(fieldDeclaration, regex, groups);
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)function);
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Filter)new RegexFilter("^fobar"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"method"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"method"}), (Function)new Identity(new Fields(new Comparable[]{"value"})), Fields.ALL);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"value"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"value", "count"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)0, null);
    }

    @Test
    public void testSplit() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("split1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("split2"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("split");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter("^68.*"));
        Each left = new Each(new Pipe("left", pipe), new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*46.*"));
        Each right = new Each(new Pipe("right", pipe), new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*102.*"));
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("split", source);
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put("left", sink1);
        sinks.put("right", sink2);
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sinks, new Pipe[]{left, right});
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, (String)"left");
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)2, (String)"right");
    }

    @Test
    public void testSplitNonSafe() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("nonsafesplit1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("nonsafesplit2"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("split");
        pipe = new Each(pipe, (Function)new TestFunction(new Fields(new Comparable[]{"ignore"}), new Tuple(new Object[]{1}), false), new Fields(new Comparable[]{"line"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter("^68.*"));
        Each left = new Each(new Pipe("left", pipe), new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*46.*"));
        Each right = new Each(new Pipe("right", pipe), new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*102.*"));
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("split", source);
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put("left", sink1);
        sinks.put("right", sink2);
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sinks, new Pipe[]{left, right});
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, (String)"left");
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)2, (String)"right");
    }

    @Test
    public void testSplitSameSourceMerged() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("splitsourcemerged"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("split");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter("^68.*"));
        Each left = new Each(new Pipe("left", pipe), new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*46.*"));
        Each right = new Each(new Pipe("right", pipe), new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*102.*"));
        GroupBy merged = new GroupBy("merged", Pipe.pipes((Pipe[])new Pipe[]{left, right}), new Fields(new Comparable[]{"line"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, (Pipe)merged);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)3);
    }

    @Test
    public void testSplitOut() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"num", "line"}), InputData.inputFileApache);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower1", sourceLower);
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("splitout1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("splitout2"), SinkMode.REPLACE);
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put("output1", sink1);
        sinks.put("output2", sink2);
        Pipe pipeLower1 = new Pipe("lower1");
        GroupBy left = new GroupBy("output1", pipeLower1, new Fields(new Comparable[]{Integer.valueOf(0)}));
        GroupBy right = new GroupBy("output2", (Pipe)left, new Fields(new Comparable[]{Integer.valueOf(0)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sinks, Pipe.pipes((Pipe[])new Pipe[]{left, right}));
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10, (String)"output1");
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10, (String)"output2");
        FieldedPipesPlatformTest.assertEquals((int)10, (int)FieldedPipesPlatformTest.asSet((Flow)flow, (Tap)sink1).size());
        FieldedPipesPlatformTest.assertEquals((int)10, (int)FieldedPipesPlatformTest.asSet((Flow)flow, (Tap)sink2).size());
    }

    @Test
    public void testSplitComplex() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("splitcomp1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("splitcomp2"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("split");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"ip"}), (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Filter)new RegexFilter("^68.*"));
        Each left = new Each(new Pipe("left", pipe), new Fields(new Comparable[]{"ip"}), (Filter)new RegexFilter(".*46.*"));
        Each right = new Each(new Pipe("right", pipe), new Fields(new Comparable[]{"ip"}), (Filter)new RegexFilter(".*102.*"));
        Map sources = Cascades.tapsMap((String)"split", (Tap)source);
        Map sinks = Cascades.tapsMap((Pipe[])Pipe.pipes((Pipe[])new Pipe[]{left, right}), (Tap[])Tap.taps((Tap[])new Tap[]{sink1, sink2}));
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sinks, new Pipe[]{left, right});
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, (String)"left");
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, (String)"right");
    }

    @Test
    public void testSplitMultiple() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sinkLeft = this.getPlatform().getTextFile(this.getOutputPath("left"), SinkMode.REPLACE);
        Tap sinkRightLeft = this.getPlatform().getTextFile(this.getOutputPath("rightleft"), SinkMode.REPLACE);
        Tap sinkRightRight = this.getPlatform().getTextFile(this.getOutputPath("rightright"), SinkMode.REPLACE);
        Pipe head = new Pipe("split");
        head = new Each(head, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        head = new GroupBy(head, new Fields(new Comparable[]{"ip"}));
        head = new Every(head, new Fields(new Comparable[]{"ip"}), (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        head = new Each(head, new Fields(new Comparable[]{"ip"}), (Filter)new RegexFilter("^68.*"));
        Each left = new Each(new Pipe("left", head), new Fields(new Comparable[]{"ip"}), (Filter)new RegexFilter(".*46.*"));
        Each right = new Each(new Pipe("right", head), new Fields(new Comparable[]{"ip"}), (Filter)new RegexFilter(".*102.*"));
        right = new GroupBy((Pipe)right, new Fields(new Comparable[]{"ip"}));
        Each rightLeft = new Each(new Pipe("rightLeft", (Pipe)right), new Fields(new Comparable[]{"ip"}), (Function)new Identity());
        Each rightRight = new Each(new Pipe("rightRight", (Pipe)right), new Fields(new Comparable[]{"ip"}), (Function)new Identity());
        Map sources = Cascades.tapsMap((String)"split", (Tap)source);
        Map sinks = Cascades.tapsMap((Pipe[])Pipe.pipes((Pipe[])new Pipe[]{left, rightLeft, rightRight}), (Tap[])Tap.taps((Tap[])new Tap[]{sinkLeft, sinkRightLeft, sinkRightRight}));
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sinks, new Pipe[]{left, rightLeft, rightRight});
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, (String)"left");
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, (String)"rightLeft");
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)1, (String)"rightRight");
    }

    @Test
    public void testConcatenation() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(InputData.inputFileUpper);
        MultiSourceTap source = new MultiSourceTap(new Tap[]{sourceLower, sourceUpper});
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("complexconcat"), SinkMode.REPLACE);
        Each pipe = new Each(new Pipe("concat"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        GroupBy splice = new GroupBy((Pipe)pipe, new Fields(new Comparable[]{"num"}));
        Flow countFlow = this.getPlatform().getFlowConnector().connect((Tap)source, sink, (Pipe)splice);
        countFlow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)countFlow, (int)10, null);
    }

    @Test
    public void testGeneratorAggregator() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new TestAggregator(new Fields(new Comparable[]{"count1"}), new Fields(new Comparable[]{"ip"}), new Tuple[]{new Tuple(new Object[]{"first1"}), new Tuple(new Object[]{"first2"})}));
        pipe = new Every(pipe, (Aggregator)new TestAggregator(new Fields(new Comparable[]{"count2"}), new Fields(new Comparable[]{"ip"}), new Tuple[]{new Tuple(new Object[]{"second"}), new Tuple(new Object[]{"second2"}), new Tuple(new Object[]{"second3"})}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("generatoraggregator"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)48, null);
    }

    @Test
    public void testReplace() throws Exception {
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), new Fields(new Comparable[]{"offset", "line"}), this.getOutputPath("replace"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser(new Fields(new Comparable[]{Integer.valueOf(0)}), "^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)parser, Fields.REPLACE);
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new Identity(Fields.ARGS), Fields.REPLACE);
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new Identity(new Fields(new Comparable[]{"line"})), Fields.REPLACE);
        pipe = new Each(pipe, (Filter)new Debug(true));
        Flow flow = this.getPlatform().getFlowConnector(this.disableDebug()).connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)10, (int)2, (Pattern)Pattern.compile("^\\d+\\s\\d+\\s[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$"));
    }

    @Test
    public void testSwap() throws Exception {
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), new Fields(new Comparable[]{"count", "ipaddress"}), this.getOutputPath("swap"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)parser, Fields.SWAP);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"ip"}), (Aggregator)new Count(new Fields(new Comparable[]{"count"})));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new Identity(new Fields(new Comparable[]{"ipaddress"})), Fields.SWAP);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)8, (int)2, (Pattern)Pattern.compile("^\\d+\\s\\d+\\s[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$"));
    }

    @Test
    public void testNone() throws Exception {
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), new Fields(new Comparable[]{"count", "ip"}), this.getOutputPath("none"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)parser, Fields.ALL);
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new NoOp(), Fields.SWAP);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, new Fields(new Comparable[]{"ip"}), (Aggregator)new Count(new Fields(new Comparable[]{"count"})));
        pipe = new Each(pipe, Fields.NONE, (Function)new Insert(new Fields(new Comparable[]{"ipaddress"}), new Object[]{"1.2.3.4"}), Fields.ALL);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)8, (int)2, (Pattern)Pattern.compile("^\\d+\\s\\d+\\s[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$"));
    }

    @Test
    public void testSplitSameSourceMergedSameName() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("splitsourcemergedsamename"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("split");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter("^68.*"));
        Each left = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*46.*"));
        Each right = new Each(pipe, new Fields(new Comparable[]{"line"}), (Filter)new RegexFilter(".*102.*"));
        GroupBy merged = new GroupBy("merged", Pipe.pipes((Pipe[])new Pipe[]{left, right}), new Fields(new Comparable[]{"line"}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, (Pipe)merged);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)3);
    }

    @Test
    public void testGroupGroup() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileApache);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields((Comparable)((Object)"ip"), String.class), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}), new Fields(new Comparable[]{"count"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("groupgroup"), SinkMode.REPLACE);
        Map<Object, Object> properties = this.getProperties();
        properties.put("cascading.serialization.types.required", "true");
        Flow flow = this.getPlatform().getFlowConnector(properties).connect(source, sink, pipe);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)8, null);
    }

    @Test
    public void testGroupByInsensitive() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"num", "char"}), " ", InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"num", "char"}), " ", InputData.inputFileUpper);
        HashMap sources = new HashMap();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("insensitivegrouping-nondeterministic"), SinkMode.REPLACE);
        Pipe pipeLower = new Pipe("lower");
        Pipe pipeUpper = new Pipe("upper");
        Merge merge = new Merge(new Pipe[]{pipeLower, pipeUpper});
        Fields charFields = new Fields(new Comparable[]{"char"});
        charFields.setComparator((Comparable)((Object)"char"), (Comparator)new LowerComparator());
        GroupBy splice = new GroupBy("groupby", (Pipe)merge, charFields);
        splice = new Every((Pipe)splice, new Fields(new Comparable[]{"char"}), (Aggregator)new Count());
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        flow.complete();
        FieldedPipesPlatformTest.validateLength((Flow)flow, (int)5, (int)1, (Pattern)Pattern.compile("^\\w+\\s2$"));
    }

    public static class LowerComparator
    implements Comparator<Comparable>,
    Hasher<Comparable>,
    Serializable {
        @Override
        public int compare(Comparable lhs, Comparable rhs) {
            return lhs.toString().toLowerCase().compareTo(rhs.toString().toLowerCase());
        }

        public int hashCode(Comparable value) {
            if (value == null) {
                return 0;
            }
            return value.toString().toLowerCase().hashCode();
        }
    }
}

