/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.TestFunction;
import cascading.operation.Aggregator;
import cascading.operation.Function;
import cascading.operation.aggregator.Count;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import java.util.HashMap;
import org.junit.Test;

public class BasicTrapPlatformTest
extends PlatformTestCase {
    @Test
    public void testTrapNamesFail() throws Exception {
        Tap source = this.getPlatform().getTextFile("foosource");
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile("footap", SinkMode.REPLACE);
        Tap trap = this.getPlatform().getTextFile("footrap", SinkMode.REPLACE);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        HashMap<String, Tap> traps = new HashMap<String, Tap>();
        sources.put("test", source);
        sinks.put("test", sink);
        traps.put("nada", trap);
        try {
            this.getPlatform().getFlowConnector().connect("trap test", sources, sinks, traps, new Pipe[]{pipe});
            BasicTrapPlatformTest.fail((String)"did not fail on missing pipe name");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTrapNamesPass() throws Exception {
        Tap source = this.getPlatform().getTextFile("foosource");
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile("foosink");
        Tap trap = this.getPlatform().getTextFile("footrap");
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        HashMap<String, Tap> traps = new HashMap<String, Tap>();
        sources.put("map", source);
        sinks.put("reduce", sink);
        traps.put("map", trap);
        this.getPlatform().getFlowConnector().connect("trap test", sources, sinks, traps, new Pipe[]{pipe});
    }

    @Test
    public void testTrapNamesPass2() throws Exception {
        Tap source = this.getPlatform().getTextFile("foosource");
        Pipe pipe = new Pipe("map");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Pipe("middle", pipe);
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy("reduce", pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        Tap sink = this.getPlatform().getTextFile("foosink");
        Tap trap = this.getPlatform().getTextFile("footrap");
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        HashMap<String, Tap> traps = new HashMap<String, Tap>();
        sources.put("map", source);
        sinks.put("reduce", sink);
        traps.put("middle", trap);
        this.getPlatform().getFlowConnector().connect("trap test", sources, sinks, traps, new Pipe[]{pipe});
    }

    @Test
    public void testTrapNamesPass3() throws Exception {
        Tap source = this.getPlatform().getTextFile("foosource");
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, new Fields(new Comparable[]{"ip"}), (Function)new TestFunction(new Fields(new Comparable[]{"test"}), null), Fields.ALL);
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Pipe("first", pipe);
        pipe = new Every(pipe, (Aggregator)new Count(), new Fields(new Comparable[]{"ip", "count"}));
        pipe = new Pipe("second", pipe);
        pipe = new Every(pipe, (Aggregator)new Count(new Fields(new Comparable[]{"count2"})), new Fields(new Comparable[]{"ip", "count", "count2"}));
        Tap sink = this.getPlatform().getTextFile("foosink");
        Tap trap = this.getPlatform().getTextFile("footrap");
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        HashMap<String, Tap> traps = new HashMap<String, Tap>();
        sources.put("test", source);
        sinks.put("second", sink);
        traps.put("first", trap);
        this.getPlatform().getFlowConnector().connect("trap test", sources, sinks, traps, new Pipe[]{pipe});
    }
}

